package cn.mctower.visitor;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

public class RoundLayout extends RelativeLayout {
    private float roundLayoutRadius = 14f;
    private int borderColor = Color.WHITE;
    private int borderWidth = 0;
    private Path roundPath;
    private RectF rectF;
    private RectF rectFBorder;
    private Paint paint;

    public RoundLayout(Context context) {
        this(context, null);
    }

    public RoundLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    private void init() {
        setWillNotDraw(false);//如果你继承的是ViewGroup,注意此行,否则draw方法是不会回调的;
        roundPath = new Path();
        rectF = new RectF();
        paint = new Paint();
        paint.setColor(Color.WHITE);
        paint.setAntiAlias(true);
    }

    private void setRoundPath() {
        //添加一个圆角矩形到path中, 如果要实现任意形状的View, 只需要手动添加path就行
        roundPath.addRoundRect(rectF, roundLayoutRadius, roundLayoutRadius, Path.Direction.CW);
    }


    public void setRoundLayoutRadius(float roundLayoutRadius) {
        this.roundLayoutRadius = roundLayoutRadius;
        setRoundPath();
        postInvalidate();
    }

    public void setRoundLayoutBorder(int borderColor,int borderWidth) {
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
        this.paint.setColor(borderColor);
        this.paint.setStrokeWidth(borderWidth *2);
        postInvalidate();
    }


    public void setBorderInfo(BorderInfo borderInfo){
        if(borderInfo != null){
            if(borderInfo.radius > 0f)
                setRoundLayoutRadius(borderInfo.radius);
            if(borderInfo.borderWidth > 0) {
                setRoundLayoutBorder(borderInfo.borderColor, borderInfo.borderWidth);
            }

        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        rectF.set(0f, 0f, getMeasuredWidth(), getMeasuredHeight());
        setRoundPath();
    }

    @Override
    public void draw(Canvas canvas) {
        if (roundLayoutRadius > 0f) {
            try {
                canvas.clipPath(roundPath);
            }catch (Exception e){
                e.printStackTrace();
            }
        }

        super.draw(canvas);

        if(borderWidth > 0){
            if(rectFBorder == null) {
                paint.setStyle(Paint.Style.STROKE);;
                rectFBorder = new RectF();
                rectFBorder.set(0, 0, getMeasuredWidth(), getMeasuredHeight());
            }
            canvas.drawRoundRect(rectFBorder,roundLayoutRadius,roundLayoutRadius,paint);
        }
    }

    public class BorderInfo {
        public float radius;
        public int borderColor;
        public int borderWidth;
    }
}