package cn.mctower.visitor;

import android.os.Bundle;
import android.os.CountDownTimer;
import android.view.View;
import android.widget.ImageView;

import com.google.gson.Gson;
import com.lidroid.xutils.ViewUtils;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.OnClick;

import java.util.HashMap;

import cn.dankal.base.activity.NetBaseAppCompatActivity;
import cn.dankal.base.http.DialogHttpCallBack;
import cn.dankal.base.http.HttpPostHelper;
import cn.dankal.base.http.NOToastHttpCallBack;
import cn.dankal.base.utils.NetPicUtil;
import cn.mctower.visitor.model.MonthCardCheckBean;
import cn.mctower.visitor.model.MonthCardRqCodeBean;

public class QRCodeActivity extends NetBaseAppCompatActivity {

    @ViewInject(R.id.codePic)
    private ImageView codePic;

    private MonthCardRqCodeBean bean;
    private NetPicUtil netPicUtil;
    private CountDownTimer countDownTimer;
    private boolean isChecking = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_qrcode);
        ViewUtils.inject(this);
        netPicUtil = new NetPicUtil();
        getCodPic();
    }

    @OnClick(R.id.backBtn)
    public void click(View view){
        switch (view.getId()){
            case R.id.backBtn:
                onBackPressed();
                break;
        }
    }

    private void getCodPic(){
        HttpPostHelper.httpGet(this, Constant.API_MONTH_CARD_CODE_PIC,new DialogHttpCallBack(this){
            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                bean = new Gson().fromJson(result, MonthCardRqCodeBean.class);
                setViews();
            }
        },null);

    }

    private void setViews(){
        if(bean != null) {
            netPicUtil.display(codePic, bean.url);
            countDownTimer = new CountDownTimer(60 * 60 * 1000, 3000) {
                @Override
                public void onTick(long l) {
                    checkStatus();
                }

                @Override
                public void onFinish() {

                }
            }.start();
        }
    }

    private void checkStatus(){
        if(!isChecking) {
            isChecking = true;
            HttpPostHelper.httpGet(this, Constant.API_MONTH_CARD_CHECK+bean.uuid,new NOToastHttpCallBack() {
                @Override
                public void successCallBack(String result) {
                    super.successCallBack(result);
                    MonthCardCheckBean resultBean = new Gson().fromJson(result,MonthCardCheckBean.class);
                    if(resultBean != null){
                        if(resultBean.submitStatus.equals("1")){
                            Bundle data = new Bundle();
                            data.putString("uuid",bean.uuid);
                            jumpActivity(MonthCardDetailActivity.class,data,false);
                            finish();
                        }
                    }
                }

                @Override
                public void requestFinish() {
                    super.requestFinish();
                    isChecking = false;
                }
            },null);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if(countDownTimer != null){
            countDownTimer.cancel();
            countDownTimer = null;
        }
    }
}
