package cn.mctower.visitor;

import android.Manifest;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.gson.Gson;
import com.lidroid.xutils.ViewUtils;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.OnClick;

import java.util.ArrayList;
import java.util.HashMap;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import cn.dankal.base.activity.NetBaseAppCompatActivity;
import cn.dankal.base.http.DialogHttpCallBack;
import cn.dankal.base.http.HttpPostHelper;
import cn.dankal.base.interfaces.IPermissionCheck;
import cn.dankal.base.utils.ToastUtils;
import cn.mctower.visitor.model.PassThroughRecordBean;
import cn.mctower.visitor.model.PassThroughRecordPageBean;
import cn.mctower.visitor.model.VisitRecordBean;
import cn.mctower.visitor.model.VisitRecordPageBean;

public class PassThroughQueryActivity extends NetBaseAppCompatActivity {


    @ViewInject(R.id.titleTv)
    TextView titleTv;
    @ViewInject(R.id.visitorFrame)
    LinearLayout visitorFrame;
    @ViewInject(R.id.visitorBtn)
    TextView visitorBtn;
    @ViewInject(R.id.searchPageFrame)
    LinearLayout searchPageFrame;
    @ViewInject(R.id.input)
    EditText input;
    @ViewInject(R.id.inputMobile)
    EditText inputMobile;
    @ViewInject(R.id.searchBtn)
    TextView searchBtn;
    @ViewInject(R.id.listView)
    RecyclerView listView;

    private ArrayList<PassThroughRecordBean> data = new ArrayList<>();
    private MyAdapter adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_pass_through_query);
        setAndroidNativeLightStatusBar(this,true);
        setStatusBarColor(this,android.R.color.white);
        ViewUtils.inject(this);

        titleTv.setText("通行查询");
        input.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_SEARCH || (event != null && event.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                click(searchBtn);
                return true;
            }
            return false;
        });

        inputMobile.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_SEARCH || (event != null && event.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                click(searchBtn);
                return true;
            }
            return false;
        });
        LinearLayoutManager lm = new LinearLayoutManager(this);
        lm.setOrientation(LinearLayoutManager.VERTICAL);
        listView.setLayoutManager(lm);
        adapter = new MyAdapter();

        listView.setAdapter(adapter);

        String[] permission = new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE};
        requestPermissions(permission, 12122, "需要存储权限", new IPermissionCheck() {
            @Override
            public void hasGotPermissions(int code) {

            }
        });

    }


    @OnClick({R.id.backBtn,R.id.visitorBtn,R.id.searchBtn})
    public void click(View view){
        switch (view.getId()){
            case R.id.backBtn:
                onBackPressed();
                break;
            case R.id.visitorBtn:
                if(!TextUtils.isEmpty(inputMobile.getText().toString().trim())){
                    doSearch(inputMobile.getText().toString().trim());
                }
                visitorFrame.setVisibility(View.GONE);
                searchPageFrame.setVisibility(View.VISIBLE);
                break;
            case R.id.searchBtn:
                if(!TextUtils.isEmpty(input.getText().toString().trim())){
                    doSearch(input.getText().toString().trim());
                }
                break;
        }
    }

    private void doSearch(String key){
        HashMap<String,String> param = new HashMap<>();
        if(!TextUtils.isEmpty(key)) {
            param.put("search", key);
            param.put("pageIndex", "1");
            param.put("pageSize", "10000");
            HttpPostHelper.httpGet(this, Constant.API_PASS_USER_LIST, new DialogHttpCallBack(this) {

                @Override
                public void requestStart() {
                    super.requestStart();
                    data.clear();
                }

                @Override
                public void successCallBack(String result) {
                    super.successCallBack(result);
                    PassThroughRecordPageBean bean = new Gson().fromJson(result, PassThroughRecordPageBean.class);
                    if (bean != null && bean.data != null) {
                        data.addAll(bean.data);
                        adapter.notifyDataSetChanged();
                    }
                }

                @Override
                public void requestFinish() {
                    super.requestFinish();
                    titleTv.setText("查询结果");
                }
            }, param);
        }else
            ToastUtils.show("请输入手机号后再进行搜索");

    }

    class MyAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder>{

        private LayoutInflater layoutInflater  = LayoutInflater.from(PassThroughQueryActivity.this);

        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View itemView = layoutInflater.inflate(R.layout.itme_pass_record, parent, false);
            return new CustomViewHolder(itemView);
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            PassThroughRecordBean bean = data.get(position);
            CustomViewHolder viewHolder = (CustomViewHolder) holder;
            viewHolder.name.setText(bean.getName());
            viewHolder.mobile.setText(bean.getPhone());
            viewHolder.company.setText(bean.getCompanyName());
            viewHolder.item.setOnClickListener(view -> {
                if(!TextUtils.isEmpty(bean.getUuid())) {
                    Intent intent = new Intent(PassThroughQueryActivity.this, PassThroughDetailActivity.class);
                    intent.putExtra("id", bean.getUuid());
                    startActivity(intent);
                }else
                    ToastUtils.show("本条邀请还未分享给访客");
            });
        }

        @Override
        public int getItemCount() {
            return data.size();
        }
    }


    class CustomViewHolder extends RecyclerView.ViewHolder{

        private RelativeLayout item;
        private TextView name;
        private TextView mobile;
        private TextView company;

        public CustomViewHolder(@NonNull View itemView) {
            super(itemView);
            item = itemView.findViewById(R.id.item);
            name = itemView.findViewById(R.id.name);
            mobile = itemView.findViewById(R.id.mobile);
            company = itemView.findViewById(R.id.company);
        }
    }
}
