package cn.mctower.visitor;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.brilliants.idcardlib.IDCardUtils;
import com.google.gson.Gson;
import com.invs.invsIdCard;
import com.lidroid.xutils.ViewUtils;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.OnClick;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureConfig;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UploadManager;
import com.qiniu.android.storage.UploadOptions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

import androidx.annotation.Nullable;
import cn.dankal.base.activity.NetBaseAppCompatActivity;
import cn.dankal.base.http.DialogHttpCallBack;
import cn.dankal.base.http.HttpPostHelper;
import cn.dankal.base.http.NOToastHttpCallBack;
import cn.dankal.base.utils.ImageUtil;
import cn.dankal.base.utils.LogUtils;
import cn.dankal.base.utils.NetPicUtil;
import cn.dankal.base.utils.ToastUtils;
import cn.mctower.visitor.model.PassRecordBean;
import cn.mctower.visitor.model.PassThroughDetailBean;
import cn.mctower.visitor.model.PassThroughSaveBean;
import cn.mctower.visitor.model.QiNiuTokenBean;

public class PassThroughDetailActivity extends NetBaseAppCompatActivity {

    @ViewInject(R.id.titleTv)
    TextView titleTv;
    @ViewInject(R.id.name)
    TextView name;
    @ViewInject(R.id.tel)
    TextView tel;
    @ViewInject(R.id.company)
    TextView company;
    @ViewInject(R.id.idAndRemarkFrame)
    RelativeLayout idAndRemarkFrame;
    @ViewInject(R.id.idNum)
    TextView idNum;
    @ViewInject(R.id.remark)
    TextView remark;

    @ViewInject(R.id.idNumFrame)
    LinearLayout idNumFrame;
    @ViewInject(R.id.inputId)
    EditText inputId;
    @ViewInject(R.id.remarkFrame)
    LinearLayout remarkFrame;
    @ViewInject(R.id.inputRemark)
    EditText inputRemark;


    @ViewInject(R.id.roundlayoutPic)
    RoundLayout roundlayoutPic;
    @ViewInject(R.id.pic)
    ImageView pic;


    @ViewInject(R.id.roundlayoutAddPic)
    RoundLayout roundlayoutAddPic;
    @ViewInject(R.id.addPic)
    TextView addPic;

    @ViewInject(R.id.bindBtn)
    TextView bindBtn;
    @ViewInject(R.id.editBtn)
    TextView editBtn;

    @ViewInject(R.id.readSuccessDialogFrame)
    RelativeLayout readSuccessDialogFrame;
    @ViewInject(R.id.idPicInDialog)
    ImageView idPicInDialog;
    @ViewInject(R.id.nameInDialog)
    TextView nameInDialog;
    @ViewInject(R.id.genderInDialog)
    TextView genderInDialog;
    @ViewInject(R.id.idCodeInDialog)
    TextView idCodeInDialog;
    @ViewInject(R.id.bindBtnInDialog)
    TextView bindBtnInDialog;

    private String id;
    private PassThroughDetailBean bean;
    private List<LocalMedia> mSelectList = new ArrayList<>();
    private LocalMedia picMedia;
    private QiNiuTokenBean qiNiuTokenBean;
    private NetPicUtil netPicUtil = new NetPicUtil();
    private invsIdCard invsIdCard;
    private UploadFileInfoBean needUploadBean;
    private String identityImgUrl;//证件的图片地址
    private String gender;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_pass_through_detail);
        setAndroidNativeLightStatusBar(this,true);
        setStatusBarColor(this,android.R.color.white);
        ViewUtils.inject(this);

        id = getIntent().getStringExtra("id");
        if(TextUtils.isEmpty(id)){
            ToastUtils.show("参数丢失");
            onBackPressed();
            return;
        }
        titleTv.setText("详情");
        roundlayoutPic.setRoundLayoutRadius(20f);
        roundlayoutPic.setRoundLayoutBorder(Color.parseColor("#999999"),1);
        roundlayoutAddPic.setRoundLayoutRadius(20f);
        roundlayoutAddPic.setRoundLayoutBorder(Color.parseColor("#999999"),1);
        initQiNiuToken();
    }

    @OnClick({R.id.backBtn,R.id.bindBtn,R.id.editBtn,R.id.addPic})
    public void click(View view){
        switch (view.getId()){
            case R.id.backBtn:
                onBackPressed();
                break;
            case R.id.bindBtn:
                readDataFromDevice();
                break;
            case R.id.editBtn:
                idAndRemarkFrame.setVisibility(View.GONE);
                roundlayoutAddPic.setVisibility(View.VISIBLE);
                idNumFrame.setVisibility(View.VISIBLE);
                remarkFrame.setVisibility(View.VISIBLE);
                bindBtn.setVisibility(View.VISIBLE);
                editBtn.setVisibility(View.GONE);
                break;
            case R.id.addPic:
                takePhoto();
                break;
        }
    }

    private void loadData(){
        HttpPostHelper.httpGet(this, Constant.API_PASS_USER_DETAIL+id, new DialogHttpCallBack(this) {

            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                bean = new Gson().fromJson(result,PassThroughDetailBean.class);
                setViews();
            }

        }, null);
    }

    private void setViews(){
        if(bean != null){
            name.setText(bean.getName());
            tel.setText(bean.getPhone());
            company.setText(bean.getCompanyName());
            if(bean.getIsBindingId() == 1){
                idAndRemarkFrame.setVisibility(View.VISIBLE);
                idNum.setText(bean.getIdentityCard());
                remark.setText(bean.getRemark());
                idNumFrame.setVisibility(View.GONE);
                inputId.setText(bean.getIdentityCard());
                remark.setText(bean.getRemark());
                remarkFrame.setVisibility(View.GONE);
                roundlayoutAddPic.setVisibility(View.GONE);
                bindBtn.setVisibility(View.GONE);
                editBtn.setVisibility(View.VISIBLE);
            }else{
                idAndRemarkFrame.setVisibility(View.GONE);
                roundlayoutPic.setVisibility(View.GONE);
                roundlayoutAddPic.setVisibility(View.VISIBLE);
                idNumFrame.setVisibility(View.VISIBLE);
                remarkFrame.setVisibility(View.VISIBLE);
                bindBtn.setVisibility(View.VISIBLE);
                editBtn.setVisibility(View.GONE);
            }

        }
    }

    private void initQiNiuToken(){
        HttpPostHelper.httpGet(this, Constant.API_GET_QINIU_TOKEN, new NOToastHttpCallBack() {
            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                LogUtils.e("aaaa","json == ====" +result);
                qiNiuTokenBean = new Gson().fromJson(result, QiNiuTokenBean.class);
                //设置身份证图片
                if(qiNiuTokenBean != null && !TextUtils.isEmpty(qiNiuTokenBean.url)){
                    if(bean.getIsBindingId() == 1) {
                        if(!TextUtils.isEmpty(bean.getIdentityImg())){
                            roundlayoutPic.setVisibility(View.VISIBLE);
                            netPicUtil.setDefaultPics(R.mipmap.ic_the, R.mipmap.ic_the, R.mipmap.ic_the);
                            netPicUtil.display(pic, qiNiuTokenBean.url + bean.getIdentityImg());
                        }else{
                            roundlayoutPic.setVisibility(View.GONE);
                        }
                    }

                }
            }

            @Override
            public void requestFinish() {
                super.requestFinish();
                loadData();
            }
        }, null);
    }

    private void takePhoto(){
        PictureSelector.create(this)
                .openCamera(PictureMimeType.ofImage())
                .theme(R.style.picture_default_style)
                .maxSelectNum(1)// 最大图片选择数量
                .minSelectNum(1)// 最小选择数量
                .imageSpanCount(4)// 每行显示个数
                .selectionMode(PictureConfig.SINGLE)// 多选 or 单选
                .previewImage(true)// 是否可预览图片
                .isCamera(true)// 是否显示拍照按钮
                .isZoomAnim(true)// 图片列表点击 缩放效果 默认true
                .enableCrop(false)// 是否裁剪
                .compress(true)// 是否压缩
                .synOrAsy(true)//同步true或异步false 压缩 默认同步
                .glideOverride(160, 160)// glide 加载宽高，越小图片列表越流畅，但会影响列表图片浏览的清晰度
                .freeStyleCropEnabled(true)// 裁剪框是否可拖拽
                .selectionMedia(mSelectList)// 是否传入已选图片
                .minimumCompressSize(100)// 小于100kb的图片不压缩
                .forResult(PictureConfig.CHOOSE_REQUEST);//结果回调onActivityResult code
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data == null) {
            return;
        }
        switch (requestCode) {
            case PictureConfig.CHOOSE_REQUEST:
                // 图片选择结果回调
                mSelectList = PictureSelector.obtainMultipleResult(data);
                if(mSelectList != null && mSelectList.size() > 0) {
                    picMedia = mSelectList.get(0);
                    pic.setImageBitmap(BitmapFactory.decodeFile(getLocalMediaPath(picMedia)));
                    roundlayoutPic.setVisibility(View.VISIBLE);
                }
                break;
        }
    }

    //获取LocalMedia的路径
    private String getLocalMediaPath(LocalMedia media){
        String path = "";
        if (media.isCut() && !media.isCompressed()) {
            // 裁剪过
            path = media.getCutPath();
        } else if (media.isCompressed() || (media.isCut() && media.isCompressed())) {
            // 压缩过,或者裁剪同时压缩过,以最终压缩过图片为准
            path = media.getCompressPath();
        } else {
            // 原图
            path = media.getPath();
        }
        return path;
    }

    /**
     * 从设备读取数据
     */
    private boolean startReadDeviceData = false;
    private CountDownTimer countDownTimer;

    private void readDataFromDevice(){
        startReadDeviceData = true;
        if(countDownTimer != null)
            countDownTimer.cancel();

        countDownTimer = new CountDownTimer(3000,1000) {
            @Override
            public void onTick(long l) {

            }

            @Override
            public void onFinish() {
                dismmisLoadingDialog();
                showReadIdAlert();
                /*invsIdCard bean = new invsIdCard();
                bean.setName("hahahah");
                bean.setSex1("男");
                bean.setIdNo("12341412312312312");
                showReadIdSuccessAlert(bean);*/
            }
        }.start();
        showLoadingDialog();
    }

    //显示去读取身份证弹框
    private void showReadIdAlert(){
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        final Dialog dialog = builder.create();
        LayoutInflater inflaterDl = LayoutInflater.from(this);
        RelativeLayout layout = (RelativeLayout) inflaterDl.inflate(R.layout.layout_dialog_read_id_info, null);
        dialog.show();
        dialog.getWindow().setContentView(layout);
        TextView btn = layout.findViewById(R.id.btn);

        btn.setOnClickListener(v -> {
            dialog.dismiss();
        });
    }

    public void readIdCardFailure(){
        if(startReadDeviceData) {
            runOnUiThread(() -> {
                showReadIdAlert();
                dismmisLoadingDialog();
            });
            if (countDownTimer != null)
                countDownTimer.cancel();
        }
    }

    public void setIdCardInfo(invsIdCard invsIdCard){
        if(startReadDeviceData) {
            runOnUiThread(() -> {
                showReadIdSuccessAlert(invsIdCard);
                dismmisLoadingDialog();
            });
            if (countDownTimer != null)
                countDownTimer.cancel();
        }

    }

    private void showReadIdSuccessAlert(invsIdCard invsIdCard){
        if (invsIdCard != null) {
            //解析身份证图片
            identityImgBitmap = IDCardUtils.Wlt2Bitmap(invsIdCard.wlt);
            idPicInDialog.setImageBitmap(identityImgBitmap);
            pic.setImageBitmap(identityImgBitmap);
            roundlayoutPic.setVisibility(View.VISIBLE);
            gender = invsIdCard.getSex1();
            inputId.setText(invsIdCard.getIdNo());
            nameInDialog.setText(invsIdCard.getName());
            genderInDialog.setText(invsIdCard.getSex1());
            idCodeInDialog.setText(invsIdCard.getIdNo());
            readSuccessDialogFrame.setVisibility(View.VISIBLE);
            bindBtnInDialog.setOnClickListener(v -> {
                readSuccessDialogFrame.setVisibility(View.GONE);
                bindId(invsIdCard);
            });

        }else{
            show("读取身份信息失败");
        }

    }

    private void bindId(invsIdCard info){
        if(info != null) {
            invsIdCard = info;
            pic.setImageBitmap(identityImgBitmap);
            name.setText(info.getName());
            idNum.setText(info.getIdNo());
            uploadImages();
        }
    }

    private Bitmap identityImgBitmap;
    private ArrayList<UploadFileInfoBean> files;//需要上传的图片信息数组
    private void uploadImages(){
        if (qiNiuTokenBean == null) {
            show("获取七牛token失败");
            return;
        }

        if(picMedia != null || identityImgBitmap != null){

            files = new ArrayList<>();
            //先处理bitmap,身份证bitmap
            if (identityImgBitmap != null) {
                try {
                    String path = ImageUtil.saveImageToFile(identityImgBitmap);
                    if (!TextUtils.isEmpty(path)) {
                        File file = new File(path);
                        LogUtils.e("aaa", "file = " + file.getAbsolutePath());
                        if (file.exists() && file.isFile()) {
                            LogUtils.e("aaa", "add idImg");
                            files.add(new UploadFileInfoBean(file, "idImg", 0));
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
//                    show(e.getMessage());
                }
            }

            if (picMedia != null) {
                File file = new File(getLocalMediaPath(picMedia));
                if (file.exists() && file.isFile())
                    files.add(new UploadFileInfoBean(file, "otherImg", 0));
            }

            if(files.size() > 0) {
                initPicUpload();
                uploadFiles();
            }else{
                uploadData();
            }
        }else{
            uploadData();
        }

    }

    private UploadManager uploadManager;
    private ProgressDialog progressDialog;
    private void initPicUpload(){
        Configuration config = new Configuration.Builder()
                .responseTimeout(60)
                .build();
        uploadManager = new UploadManager(config);
        progressDialog = new ProgressDialog(this,ProgressDialog.THEME_HOLO_LIGHT);
        progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        progressDialog.setTitle("上传图片");
        progressDialog.setMax(100);
        progressDialog.setProgress(0);
        progressDialog.show();
    }

    private void uploadFiles(){
        if(uploadManager != null){
            needUploadBean = null;
            //检测是否还有待上传的文件
            for(UploadFileInfoBean bean : files){
                if(bean.status == 0) {
                    needUploadBean = bean;
                    break;
                }
            }
            if(needUploadBean != null){ //上传图片
                String keyStr = "mctower_pic_" + System.currentTimeMillis() + "_" + new Random().nextInt(99999);
                String msg = "";
                switch (needUploadBean.type){
                    case "idImg":
                        msg = "正在上传身份证头像";
                        break;
                    case "otherImg":
                        msg = "正在上传证件照片";
                        break;
                }
                progressDialog.setMessage(msg);
                uploadManager.put(needUploadBean.file, keyStr, qiNiuTokenBean.token,
                        (key, info, res) -> {
                            //res包含hash、key等信息，具体字段取决于上传策略的设置
                            if (info.isOK()) {
                                LogUtils.e("qiniu", "Upload Success");
                                needUploadBean.url = key;
                                needUploadBean.status = 1;
                                progressDialog.dismiss();
                            } else {
                                LogUtils.e("qiniu", "Upload Fail info=" + info + " res = " + res);
                                //如果失败，这里可以把info信息上报自己的服务器，便于后面分析上传错误原因
                                runOnUiThread(new Runnable() {
                                    public void run() {
                                        show("上传图片失败");
                                    }
                                });

                                needUploadBean.status = -1;
                                progressDialog.dismiss();
                            }
                            uploadFiles();
//                            LogUtils.e("qiniu", key + ",\r\n " + info + ",\r\n " + res);
                        }, new UploadOptions(null, null, false,
                                (key, percent) -> {
                                    progressDialog.setMax(100);
                                    progressDialog.setProgress((int) (percent * 100));
                                    LogUtils.e("qiniu", "key = " + key + ",percent = " + percent);
                                }, null));
            }else{ //图片都已上传过，提交数据到服务器
                for(UploadFileInfoBean bean : files){
                    if(bean.status == 1) {
                        switch (bean.type){
                            case "idImg":
                            case "otherImg":
                                identityImgUrl = bean.url;
                                break;
                        }
                    }
                }
                uploadData();
            }
        }

    }

    private void uploadData(){
        if(TextUtils.isEmpty(inputId.getText().toString())){
            ToastUtils.show("请输入证件号码");
            return;
        }
        if(TextUtils.isEmpty(identityImgUrl)){
            ToastUtils.show("请设置证件照片");
            return;
        }

        PassThroughSaveBean saveBean = new PassThroughSaveBean();
        saveBean.userUuid = bean.getUserUuid();
        saveBean.userName = bean.getName();
        saveBean.identityCard = inputId.getText().toString();
        saveBean.identityImg = identityImgUrl;
        saveBean.remark = inputRemark.getText().toString();
        HttpPostHelper.httpPutJson(this, Constant.API_PASS_USER_BIND, new DialogHttpCallBack(this) {

            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                ToastUtils.show("操作成功");
                loadData();
            }
        }, new Gson().toJson(saveBean));
    }

    class UploadFileInfoBean{
        public File file;
        public String type;
        public int status; // 0: 待上传  1：上传成功   -1：上传失败
        public String url;

        public UploadFileInfoBean(File file, String type, int stutas) {
            this.file = file;
            this.type = type;
            this.status = stutas;

        }
    }

}
