package cn.mctower.visitor;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.google.gson.Gson;
import com.lidroid.xutils.ViewUtils;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.OnClick;

import cn.dankal.base.activity.NetBaseAppCompatActivity;
import cn.dankal.base.http.DialogHttpCallBack;
import cn.dankal.base.http.HttpPostHelper;
import cn.dankal.base.http.NOToastHttpCallBack;
import cn.dankal.base.utils.LogUtils;
import cn.dankal.base.utils.NetPicUtil;
import cn.dankal.base.utils.ScreenUtil;
import cn.dankal.base.utils.ToastUtils;
import cn.dankal.base.utils.UIUtil;
import cn.mctower.visitor.model.MonthCardDetailBean;
import cn.mctower.visitor.model.MonthCardRqCodeBean;
import cn.mctower.visitor.model.QiNiuTokenBean;

public class MonthCardDetailActivity extends NetBaseAppCompatActivity {

    @ViewInject(R.id.titleTv)
    TextView titleTv;
    @ViewInject(R.id.frame1)
    RoundLayout frame1;
    @ViewInject(R.id.frame2)
    RoundLayout frame2;
    @ViewInject(R.id.picsFrame)
    RoundLayout picsFrame;
    @ViewInject(R.id.openTime)
    TextView openTime;
    @ViewInject(R.id.availableTime)
    TextView availableTime;
    @ViewInject(R.id.bindTimes)
    TextView bindTimes;
    @ViewInject(R.id.carCardNum)
    TextView carCardNum;
    @ViewInject(R.id.carNum)
    TextView carNum;
    @ViewInject(R.id.applyReason)
    TextView applyReason;
    @ViewInject(R.id.pic1)
    ImageView pic1;
    @ViewInject(R.id.pic2)
    ImageView pic2;
    @ViewInject(R.id.pic3)
    ImageView pic3;
    @ViewInject(R.id.bigPicFrame)
    LinearLayout bigPicFrame;
    @ViewInject(R.id.bigPic)
    ImageView bigPic;
    @ViewInject(R.id.bindSuccessFrame)
    LinearLayout bindSuccessFrame;


    private MonthCardDetailBean bean;
    private NetPicUtil netPicUtil;
    private QiNiuTokenBean qiNiuTokenBean;

    private String uuid;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_month_card_detail);
        setAndroidNativeLightStatusBar(this,true);
        setStatusBarColor(this,android.R.color.white);
        ViewUtils.inject(this);
        uuid = getIntent().getStringExtra("uuid");
        titleTv.setText("月卡信息");
        netPicUtil = new NetPicUtil();
        frame1.setRoundLayoutRadius(20f);
        frame2.setRoundLayoutRadius(20f);
        picsFrame.setRoundLayoutRadius(20f);

        loadData();
    }

    @OnClick({R.id.backBtn,R.id.pic1,R.id.pic2,R.id.pic3,R.id.bigPicFrame,R.id.bigPic,R.id.successBtn,R.id.bindBtn})
    public void click(View view) {
        switch (view.getId()) {
            case R.id.backBtn:
                onBackPressed();
                break;
            case R.id.pic1:
            case R.id.pic2:
            case R.id.pic3:
                showBigPic(view.getId());
                break;
            case R.id.bigPicFrame:
                break;
            case R.id.bigPic:
                bigPicFrame.setVisibility(View.GONE);
                break;
            case R.id.successBtn:
                finish();
                break;
            case R.id.bindBtn:
                submit();
                break;
        }
    }

    @Override
    public void onBackPressed() {
        if(bigPicFrame.getVisibility() == View.VISIBLE || bindSuccessFrame.getVisibility() == View.VISIBLE){
            bigPicFrame.setVisibility(View.GONE);
        }else
            super.onBackPressed();
    }

    private void loadData(){
        HttpPostHelper.httpGet(this, Constant.API_MONTH_CARD_DETAIL+uuid,new DialogHttpCallBack(this){
            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                bean = new Gson().fromJson(result, MonthCardDetailBean.class);
                setViews();
            }
        },null);
    }

    private void submit(){
        HttpPostHelper.httpPutJson(this, Constant.API_MONTH_CARD_DETAIL+uuid,new DialogHttpCallBack(this){
            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                bindSuccessFrame.setVisibility(View.VISIBLE);
            }
        },null);
    }

    private void setViews(){
        if(bean != null){
            if(bean.monthCard != null) {
                openTime.setText(bean.monthCard.startTime);
                availableTime.setText(bean.monthCard.endTime);
                carCardNum.setText(bean.monthCard.useCardNo);
                carNum.setText(bean.cardNo);
                applyReason.setText(bean.description);
            }
            bindTimes.setText(bean.replaceCount+"次");
            initQiNiuToken();
        }
    }

    private void initQiNiuToken(){
        HttpPostHelper.httpGet(this, Constant.API_GET_QINIU_TOKEN, new NOToastHttpCallBack() {
            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                LogUtils.e("aaaa","json == ====" +result);
                qiNiuTokenBean = new Gson().fromJson(result, QiNiuTokenBean.class);
                //设置身份证图片
                if(qiNiuTokenBean != null && !TextUtils.isEmpty(qiNiuTokenBean.url)){
                    if(bean.vehicleImgArray != null){
                        int i = 0 ;
                        for(String url : bean.vehicleImgArray){
                            if(i == 0) {
                                pic1.setVisibility(View.VISIBLE);
                                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) pic1.getLayoutParams();
                                lp.width = ScreenUtil.getScreenWidth(MonthCardDetailActivity.this) - UIUtil.Dp2Px(MonthCardDetailActivity.this,84);
                                pic1.setLayoutParams(lp);
                                netPicUtil.display(pic1,qiNiuTokenBean.url + url);
                            }
                            else if(i == 1) {
                                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) pic1.getLayoutParams();
                                lp.width = (ScreenUtil.getScreenWidth(MonthCardDetailActivity.this) - UIUtil.Dp2Px(MonthCardDetailActivity.this,84)) / 2;
                                pic1.setLayoutParams(lp);
                                pic2.setVisibility(View.VISIBLE);
                                LinearLayout.LayoutParams lp2 = (LinearLayout.LayoutParams) pic2.getLayoutParams();
                                lp2.width = (ScreenUtil.getScreenWidth(MonthCardDetailActivity.this) - UIUtil.Dp2Px(MonthCardDetailActivity.this,84)) / 2;
                                pic2.setLayoutParams(lp2);
                                netPicUtil.display(pic2,qiNiuTokenBean.url + url);
                            }
                            else if(i == 2) {
                                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) pic1.getLayoutParams();
                                lp.width = (ScreenUtil.getScreenWidth(MonthCardDetailActivity.this) - UIUtil.Dp2Px(MonthCardDetailActivity.this,84)) / 3;
                                pic1.setLayoutParams(lp);
                                LinearLayout.LayoutParams lp2 = (LinearLayout.LayoutParams) pic2.getLayoutParams();
                                lp2.width = (ScreenUtil.getScreenWidth(MonthCardDetailActivity.this) - UIUtil.Dp2Px(MonthCardDetailActivity.this,84)) / 3;
                                pic2.setLayoutParams(lp2);
                                LinearLayout.LayoutParams lp3 = (LinearLayout.LayoutParams) pic3.getLayoutParams();
                                lp3.width = (ScreenUtil.getScreenWidth(MonthCardDetailActivity.this) - UIUtil.Dp2Px(MonthCardDetailActivity.this,84)) / 3;
                                pic2.setLayoutParams(lp3);
                                pic3.setVisibility(View.VISIBLE);
                                netPicUtil.display(pic3,qiNiuTokenBean.url + url);
                            }
                            i++;
                            if(i > 3)
                                break;
                        }
                    }else{
                        pic1.setVisibility(View.GONE);
                        pic2.setVisibility(View.GONE);
                        pic3.setVisibility(View.GONE);
                    }
                }
            }
        }, null);
    }


    private void showBigPic(int id){
        if(qiNiuTokenBean != null && !TextUtils.isEmpty(qiNiuTokenBean.url)) {
            if (bean.vehicleImgArray != null && bean.vehicleImgArray.size() > 0) {
                switch (id) {
                    case R.id.pic1:
                        if (bean.vehicleImgArray.size() > 0)
                            netPicUtil.display(bigPic, qiNiuTokenBean.url + bean.vehicleImgArray.get(0));
                        break;
                    case R.id.pic2:
                        if (bean.vehicleImgArray.size() > 1)
                            netPicUtil.display(bigPic, qiNiuTokenBean.url + bean.vehicleImgArray.get(1));
                        break;
                    case R.id.pic3:
                        if (bean.vehicleImgArray.size() > 2)
                            netPicUtil.display(bigPic, qiNiuTokenBean.url + bean.vehicleImgArray.get(2));
                        break;
                }
                bigPicFrame.setVisibility(View.VISIBLE);
            }
        } else
            ToastUtils.show("图片路劲信息获取失败");
    }
}
