package cn.mctower.visitor;

import android.Manifest;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.brilliants.idcardlib.IDCard;
import com.brilliants.idcardlib.IDCardCallBack;
import com.google.gson.Gson;
import com.invs.invsIdCard;
import com.lidroid.xutils.ViewUtils;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.OnClick;

import java.util.ArrayList;
import java.util.HashMap;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import cn.dankal.base.activity.NetBaseAppCompatActivity;
import cn.dankal.base.http.DialogHttpCallBack;
import cn.dankal.base.http.HttpPostHelper;
import cn.dankal.base.interfaces.IPermissionCheck;
import cn.dankal.base.utils.LogUtils;
import cn.dankal.base.utils.ToastUtils;
import cn.mctower.visitor.model.VisitRecordBean;
import cn.mctower.visitor.model.VisitRecordPageBean;

public class MainActivity extends NetBaseAppCompatActivity {

    @ViewInject(R.id.titleTv)
    TextView titleTv;
    @ViewInject(R.id.visitorFrame)
    LinearLayout visitorFrame;
    @ViewInject(R.id.visitorBtn)
    TextView visitorBtn;
    @ViewInject(R.id.searchPageFrame)
    LinearLayout searchPageFrame;
    @ViewInject(R.id.inputTipFrame)
    LinearLayout inputTipFrame;
    @ViewInject(R.id.clearBtn)
    ImageView clearBtn;
    @ViewInject(R.id.input)
    EditText input;
    @ViewInject(R.id.searchBtn)
    TextView searchBtn;
    @ViewInject(R.id.tip)
    TextView tip;
    @ViewInject(R.id.listView)
    RecyclerView listView;

    private ArrayList<VisitRecordBean> data = new ArrayList<>();
    private MyAdapter adapter;
    private invsIdCard invsIdCard;
//    private IDCard idCard;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        setAndroidNativeLightStatusBar(this,true);
        setStatusBarColor(this,android.R.color.white);
        ViewUtils.inject(this);

        visitorFrame.setVisibility(View.GONE);
        searchPageFrame.setVisibility(View.VISIBLE);

        titleTv.setText("信息");
        input.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean b) {
                if(b){
                    inputTipFrame.setVisibility(View.GONE);
                }else{
                    if(TextUtils.isEmpty(input.getText().toString()))
                        inputTipFrame.setVisibility(View.VISIBLE);
                }
            }
        });

        input.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                clearBtn.setVisibility(!TextUtils.isEmpty(input.getText().toString()) ? View.VISIBLE : View.GONE);
            }
        });

        input.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_SEARCH || (event != null && event.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                click(searchBtn);
                return true;
            }
            return false;
        });
        LinearLayoutManager lm = new LinearLayoutManager(this);
        lm.setOrientation(LinearLayoutManager.VERTICAL);
        listView.setLayoutManager(lm);
        adapter = new MyAdapter();

        listView.setAdapter(adapter);

        String[] permission = new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE};
        requestPermissions(permission, 12122, "需要存储权限", new IPermissionCheck() {
            @Override
            public void hasGotPermissions(int code) {

            }
        });

        readDataFromDevice();

    }

    @OnClick({R.id.backBtn,R.id.visitorBtn,R.id.clearBtn,R.id.searchBtn})
    public void click(View view){
        switch (view.getId()){
            case R.id.backBtn:
                onBackPressed();
                break;
            case R.id.visitorBtn:
                visitorFrame.setVisibility(View.GONE);
                searchPageFrame.setVisibility(View.VISIBLE);
                break;
            case R.id.clearBtn:
                input.setText("");
                break;
            case R.id.searchBtn:
                doSearch();
                break;
        }
    }

    /*@Override
    public void onBackPressed() {
        if(searchPageFrame.getVisibility() == View.VISIBLE){
            visitorFrame.setVisibility(View.VISIBLE);
            searchPageFrame.setVisibility(View.GONE);
            data.clear();
            adapter.notifyDataSetChanged();
        }else
            super.onBackPressed();
    }*/

    private void doSearch(){
        String key = input.getText().toString().trim();
        HashMap<String,String> param = new HashMap<>();
//        if(!TextUtils.isEmpty(key))
            param.put("search",key);
        param.put("pageIndex","1");
        param.put("pageSize","10000");
        HttpPostHelper.httpGet(this,Constant.API_VISIT_RECORD_LIST,new DialogHttpCallBack(this){

            @Override
            public void requestStart() {
                super.requestStart();
                data.clear();
            }

            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                VisitRecordPageBean bean = new Gson().fromJson(result,VisitRecordPageBean.class);
                if(bean != null && bean.data != null){
                    data.addAll(bean.data);
                    adapter.notifyDataSetChanged();
                }
            }

            @Override
            public void requestFinish() {
                super.requestFinish();
                setTip();
            }
        },param);

    }

    private void setTip(){
        if(data.size() > 0){
            tip.setVisibility(View.GONE);
        }else{
            tip.setText("系统中无匹配姓名的记录");
            tip.setVisibility(View.VISIBLE);
        }
    }

    /**
     * 从设备读取数据
     */
    private void readDataFromDevice(){
        /*idCard = new IDCard(getApplicationContext(), new IDCardCallBack() {
            @Override
            public void idCardDeviceComment() {
//                ToastUtils.show("读卡器已连接");
            }

            @Override
            public void idCardDeviceUnComment() {
//                ToastUtils.show("读卡器已断开");
            }

            @Override
            public void readIDCardDataFail() {
                //读卡器读取身份证信息失败
                runOnUiThread(() -> ToastUtils.show("读取失败"));
            }

            @Override
            public void readIDCardData(invsIdCard invsIdCard, boolean b) {
                runOnUiThread(() -> input.setText(invsIdCard.getName()));
            }
        });*/
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
//        idCard.unInit();
    }

    public void setIdCardInfo(invsIdCard invsIdCard){
        if(invsIdCard != null){
            runOnUiThread(() -> input.setText(invsIdCard.getName()));
        }
    }

    public void readIdCardFailure(){
        runOnUiThread(() -> ToastUtils.show("读取失败"));
    }

    class MyAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder>{

        private LayoutInflater layoutInflater  = LayoutInflater.from(MainActivity.this);

        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View itemView = layoutInflater.inflate(R.layout.itme_visit_record, parent, false);
            return new CustomViewHolder(itemView);
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            VisitRecordBean bean = data.get(position);
            CustomViewHolder viewHolder = (CustomViewHolder) holder;
            viewHolder.name.setText(bean.clientName);
            viewHolder.mobile.setText(bean.phone);
            viewHolder.company.setText(bean.companyName);
            viewHolder.staffName.setText(bean.staffName);
            viewHolder.time.setText(bean.visitorTime);
            viewHolder.item.setOnClickListener(view -> {
                if(!TextUtils.isEmpty(bean.userUuid)) {
                    Intent intent = new Intent(MainActivity.this, DetailActivity.class);
                    intent.putExtra("id", bean.userUuid);
                    startActivity(intent);
                }else
                    ToastUtils.show("本条邀请还未分享给访客");
            });
        }

        @Override
        public int getItemCount() {
            return data.size();
        }
    }


    class CustomViewHolder extends RecyclerView.ViewHolder{

        private RelativeLayout item;
        private TextView name;
        private TextView mobile;
        private TextView company;
        private TextView staffName;
        private TextView time;

        public CustomViewHolder(@NonNull View itemView) {
            super(itemView);
            item = itemView.findViewById(R.id.item);
            name = itemView.findViewById(R.id.name);
            staffName = itemView.findViewById(R.id.staffName);
            mobile = itemView.findViewById(R.id.mobile);
            company = itemView.findViewById(R.id.company);
            time = itemView.findViewById(R.id.time);
        }
    }
}
