package cn.mctower.visitor;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;

import com.brilliants.idcardlib.IDCard;
import com.brilliants.idcardlib.IDCardCallBack;
import com.invs.invsIdCard;
import com.nostra13.universalimageloader.cache.disc.naming.Md5FileNameGenerator;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.tencent.bugly.Bugly;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import cn.dankal.base.activity.NetBaseAppCompatActivity;

/**
 * Author：Alex tang
 * Date：2020-07-20
 * Time：11:41
 * Description：
 */
public class MCTowerApplication extends Application {


    private static Context context;
    private static IDCard idCard;
    private Activity currentActivity;

    @Override
    public void onCreate() {
        super.onCreate();
        this.context = this;

        //初始化imageloader
        ImageLoaderConfiguration.Builder config = new ImageLoaderConfiguration.Builder(context);
        config.threadPriority(Thread.NORM_PRIORITY - 2);
        config.denyCacheImageMultipleSizesInMemory();
        config.diskCacheFileNameGenerator(new Md5FileNameGenerator());
        config.diskCacheSize(300 * 1024 * 1024); // 300 MiB
        config.tasksProcessingOrder(QueueProcessingType.LIFO);
        ImageLoader.getInstance().init(config.build());

        Bugly.init(getApplicationContext(), "2c5f751c8c", true);

        registerActivityLifecycleCallbacks(new ActivityLifecycleCallbacks() {
            @Override
            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
                currentActivity = activity;
            }

            @Override
            public void onActivityStarted(@NonNull Activity activity) {
                currentActivity = activity;
            }

            @Override
            public void onActivityResumed(@NonNull Activity activity) {
                currentActivity = activity;
            }

            @Override
            public void onActivityPaused(@NonNull Activity activity) {

            }

            @Override
            public void onActivityStopped(@NonNull Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {

            }

            @Override
            public void onActivityDestroyed(@NonNull Activity activity) {

            }
        });

        idCard = new IDCard(this, new IDCardCallBack() {
            @Override
            public void idCardDeviceComment() {

            }

            @Override
            public void idCardDeviceUnComment() {

            }

            @Override
            public void readIDCardDataFail() {
                if(currentActivity != null){
                    if(currentActivity instanceof MainActivity){
                        ((MainActivity)currentActivity).readIdCardFailure();
                    }else if(currentActivity instanceof DetailActivity){
                        ((DetailActivity)currentActivity).readIdCardFailure();
                    }else if(currentActivity instanceof PassThroughDetailActivity){
                        ((PassThroughDetailActivity)currentActivity).readIdCardFailure();
                    }
                }
            }

            @Override
            public void readIDCardData(invsIdCard invsIdCard, boolean b) {
                if(currentActivity != null){
                    if(currentActivity instanceof MainActivity){
                        ((MainActivity)currentActivity).setIdCardInfo(invsIdCard);
                    }else if(currentActivity instanceof DetailActivity){
                        ((DetailActivity)currentActivity).setIdCardInfo(invsIdCard);
                    }else if(currentActivity instanceof PassThroughDetailActivity){
                        ((PassThroughDetailActivity)currentActivity).setIdCardInfo(invsIdCard);
                    }
                }
            }
        });

    }

    @Override
    public void onTerminate() {
        super.onTerminate();
        if(idCard != null)
            idCard.unInit();
    }

    public static Context getContext(){
        return context;
    }
}
