package cn.mctower.visitor;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.lidroid.xutils.ViewUtils;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.OnClick;

import androidx.annotation.MainThread;
import cn.dankal.base.activity.NetBaseAppCompatActivity;

public class HomePageActivity extends NetBaseAppCompatActivity {

    @ViewInject(R.id.titleTv)
    TextView titleTv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_home_page);
        setAndroidNativeLightStatusBar(this,true);
        setStatusBarColor(this,android.R.color.white);
        ViewUtils.inject(this);
        titleTv.setText("首页");
    }

    @OnClick({R.id.backBtn,R.id.passCode, R.id.visitor, R.id.monthCard})
    public void click(View view){
        switch (view.getId()){
            case R.id.backBtn:
                onBackPressed();
                break;
            case R.id.passCode:
                jumpActivity(PassThroughQueryActivity.class,false);
                break;
            case R.id.visitor:
                jumpActivity(MainActivity.class,false);
                break;
            case R.id.monthCard:
                jumpActivity(QRCodeActivity.class,false);
                break;
        }
    }
}
