package cn.mctower.visitor;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.brilliants.idcardlib.IDCard;
import com.brilliants.idcardlib.IDCardCallBack;
import com.brilliants.idcardlib.IDCardUtils;
import com.google.gson.Gson;
import com.invs.invsIdCard;
import com.lidroid.xutils.ViewUtils;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.OnClick;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureConfig;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UploadManager;
import com.qiniu.android.storage.UploadOptions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import cn.dankal.base.activity.NetBaseAppCompatActivity;
import cn.dankal.base.http.DialogHttpCallBack;
import cn.dankal.base.http.HttpPostHelper;
import cn.dankal.base.http.NOToastHttpCallBack;
import cn.dankal.base.utils.ImageUtil;
import cn.dankal.base.utils.LogUtils;
import cn.dankal.base.utils.NetPicUtil;
import cn.dankal.base.utils.ToastUtils;
import cn.dankal.base.utils.UIUtil;
import cn.dankal.base.views.CircleImageView;
import cn.mctower.visitor.model.DetailPageBean;
import cn.mctower.visitor.model.QiNiuTokenBean;
import cn.mctower.visitor.model.RemarkBean;
import cn.mctower.visitor.model.VisitRecordBean;

public class DetailActivity extends NetBaseAppCompatActivity {

    @ViewInject(R.id.titleTv)
    TextView titleTv;
    @ViewInject(R.id.headPic)
    CircleImageView headPic;
    @ViewInject(R.id.name)
    TextView name;
    @ViewInject(R.id.idPic)
    ImageView idPic;
    @ViewInject(R.id.realName)
    TextView realName;
    @ViewInject(R.id.gender)
    TextView gender;
    @ViewInject(R.id.idNoTitle)
    TextView idNoTitle;
    @ViewInject(R.id.idCode)
    TextView idCode;
    @ViewInject(R.id.idNum)
    TextView idNum;
    @ViewInject(R.id.takePhotoFrame)
    LinearLayout takePhotoFrame;
    @ViewInject(R.id.facePicBtn)
    RelativeLayout facePicBtn;
    @ViewInject(R.id.idPicBtn)
    RelativeLayout idPicBtn;
    @ViewInject(R.id.idPicture)
    ImageView idPicture;
    @ViewInject(R.id.addIDPicTipFrame)
    LinearLayout addIDPicTipFrame;
    @ViewInject(R.id.facePicture)
    ImageView facePicture;
    @ViewInject(R.id.addFacePicTipFrame)
    LinearLayout addFacePicTipFrame;
    @ViewInject(R.id.listView)
    RecyclerView listView;
    @ViewInject(R.id.noteInput)
    EditText noteInput;
    @ViewInject(R.id.bindBtn)
    TextView bindBtn;
    @ViewInject(R.id.otherBindBtn)
    TextView otherBindBtn;

    @ViewInject(R.id.readSuccessDialogFrame)
    RelativeLayout readSuccessDialogFrame;
    @ViewInject(R.id.idPicInDialog)
    ImageView idPicInDialog;
    @ViewInject(R.id.nameInDialog)
    TextView nameInDialog;
    @ViewInject(R.id.genderInDialog)
    TextView genderInDialog;
    @ViewInject(R.id.idCodeInDialog)
    TextView idCodeInDialog;
    @ViewInject(R.id.bindBtnInDialog)
    TextView bindBtnInDialog;

    @ViewInject(R.id.otherBindDialogFrame)
    RelativeLayout otherBindDialogFrame;
    @ViewInject(R.id.otherIdInput)
    EditText otherIdInput;
    @ViewInject(R.id.otherIdPicture)
    ImageView otherIdPicture;

    private String id;
    private MyAdapter adapter;
    private ArrayList<VisitRecordBean> data = new ArrayList<>();
    private DetailPageBean bean;
    private NetPicUtil netPicUtil = new NetPicUtil(R.mipmap.ic_tou,R.mipmap.ic_tou,R.mipmap.ic_tou);
    //    private IDCard idCard;
    private List<LocalMedia> mSelectList = new ArrayList<>();
    private LocalMedia idPicMedia;
    private LocalMedia facePicMedia;
    private boolean isTakeIdPicNow = false;
    private invsIdCard invsIdCard;
    private Bitmap identityImgBitmap;
    private QiNiuTokenBean qiNiuTokenBean;
    private CountDownTimer countDownTimer;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_detail);
        setAndroidNativeLightStatusBar(this,true);
        setStatusBarColor(this,android.R.color.white);
        ViewUtils.inject(this);
        id = getIntent().getStringExtra("id");
        titleTv.setText("详情");
        int width = (UIUtil.getScreenPhysicalSize(this).widthPixels - UIUtil.Dp2Px(this,22f) * 2 - UIUtil.Dp2Px(this,15f) ) / 2;
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) idPicBtn.getLayoutParams();
        lp.height = (int)(width * 1.15);
        lp.width = width;
        idPicBtn.setLayoutParams(lp);
        LinearLayout.LayoutParams lp1 = (LinearLayout.LayoutParams) facePicBtn.getLayoutParams();
        lp1.height = (int)(width * 1.15);
        lp1.width = width;
        facePicBtn.setLayoutParams(lp1);

        LinearLayoutManager lm = new LinearLayoutManager(this);
        lm.setOrientation(LinearLayoutManager.VERTICAL);
        listView.setLayoutManager(lm);
        adapter = new MyAdapter();
        listView.setAdapter(adapter);


        initQiNiuToken();

    }

    private void loadData(){
        HttpPostHelper.httpGet(this, Constant.API_VISIT_DETAIL+id,new DialogHttpCallBack(this){
            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                bean = new Gson().fromJson(result,DetailPageBean.class);
                setViews();
            }
        },null);

    }

    private void initQiNiuToken(){
        HttpPostHelper.httpGet(this, Constant.API_GET_QINIU_TOKEN, new NOToastHttpCallBack() {
            @Override
            public void successCallBack(String result) {
                super.successCallBack(result);
                LogUtils.e("aaaa","json == ====" +result);
                qiNiuTokenBean = new Gson().fromJson(result, QiNiuTokenBean.class);
                //设置身份证图片
                if(qiNiuTokenBean != null && !TextUtils.isEmpty(qiNiuTokenBean.url)){
                    if(bean.user.isBindingId != 0) {
                        if (!TextUtils.isEmpty(bean.user.identityImg)) {
                            netPicUtil.setDefaultPics(R.mipmap.ic_the, R.mipmap.ic_the, R.mipmap.ic_the);
                            netPicUtil.display(idPic, qiNiuTokenBean.url + bean.user.identityImg);
                        }

                        if (!TextUtils.isEmpty(bean.user.certificatesImg)) {
                            addIDPicTipFrame.setVisibility(View.GONE);
                            idPicture.setVisibility(View.VISIBLE);
                            netPicUtil.display(idPicture, qiNiuTokenBean.url + bean.user.certificatesImg);
                        }
                    }
                    if(!TextUtils.isEmpty(bean.user.faceImg))
                        netPicUtil.display(facePicture,qiNiuTokenBean.url+bean.user.faceImg);
                }
            }

            @Override
            public void requestFinish() {
                super.requestFinish();
                loadData();
            }
        }, null);
    }

    private void setViews(){
        if(bean != null){
            if(bean.user != null) {
                if (!TextUtils.isEmpty(bean.user.wxImg)){
                    netPicUtil.display(headPic,bean.user.wxImg);
                }
                name.setText(bean.user.wxName);
                realName.setText(bean.user.userName);
                gender.setText(bean.user.sex);
                idCode.setText(bean.user.identityCard);
                idNum.setText(bean.user.isBindingId != 0 ? "证件号码："+bean.user.identityCard : "");
                bindBtn.setText(bean.user.isBindingId == 1 ? "更新" : "绑定");
                otherBindBtn.setText(bean.user.isBindingId == 2 ? "更新其他证件" : "绑定其他证件");
//                idNoTitle.setVisibility(bean.user.isBindingId == 1 ? View.INVISIBLE : View.VISIBLE);
//                idCode.setVisibility(bean.user.isBindingId == 1 ? View.INVISIBLE : View.VISIBLE);
                noteInput.setText(bean.user.remark);
            }
            if(bean.visitList != null){
                data.addAll(bean.visitList);
                adapter.notifyDataSetChanged();
            }
        }
    }

    //显示去读取身份证弹框
    private void showReadIdAlert(){
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        final Dialog dialog = builder.create();
        LayoutInflater inflaterDl = LayoutInflater.from(this);
        RelativeLayout layout = (RelativeLayout) inflaterDl.inflate(R.layout.layout_dialog_read_id_info, null);
        dialog.show();
        dialog.getWindow().setContentView(layout);
        TextView btn = layout.findViewById(R.id.btn);

        btn.setOnClickListener(v -> {
            dialog.dismiss();
        });
    }

    private void showReadIdSuccessAlert(invsIdCard invsIdCard){
        if (invsIdCard != null) {

//            identityImgBitmap = BitmapFactory.decodeResource(getResources(),R.mipmap.ic_tou);
            //解析身份证图片
            identityImgBitmap = IDCardUtils.Wlt2Bitmap(invsIdCard.wlt);
            idPicInDialog.setImageBitmap(identityImgBitmap);
            nameInDialog.setText(invsIdCard.getName());
            genderInDialog.setText(invsIdCard.getSex1());
            idCodeInDialog.setText(invsIdCard.getIdNo());
            readSuccessDialogFrame.setVisibility(View.VISIBLE);
            bindBtnInDialog.setOnClickListener(v -> {
                readSuccessDialogFrame.setVisibility(View.GONE);
                bindId(invsIdCard);
            });

        }else{
            show("读取身份信息失败");
        }


    }

    private void bindId(invsIdCard info){
        if(info != null) {
            invsIdCard = info;
            idPic.setImageBitmap(identityImgBitmap);
            realName.setText(info.getName());
            gender.setText(info.getSex1());
            idCode.setText(info.getIdNo());
            uploadImages(false);
        }
    }

    private String identityImgUrl; //身份证照片url
    private String certificatesImgUrl; //证件照片url
    private String faceImgUrl;  //脸部照片url
    private UploadFileInfoBean needUploadBean;
    private ArrayList<UploadFileInfoBean> files;//需要上传的图片信息数组
    private void uploadImages(boolean isBindOther){
        if (qiNiuTokenBean == null) {
            show("获取七牛token失败");
            return;
        }

        if(facePicMedia != null || idPicMedia != null || identityImgBitmap != null){

            files = new ArrayList<>();
            //先处理bitmap,身份证bitmap
            if(!isBindOther) { //绑定身份证
                if (identityImgBitmap != null) {
                    try {
                        String path = ImageUtil.saveImageToFile(identityImgBitmap);
                        if (!TextUtils.isEmpty(path)) {
                            File file = new File(path);
                            LogUtils.e("aaa", "file = " + file.getAbsolutePath());
                            if (file.exists() && file.isFile()) {
                                LogUtils.e("aaa", "add idImg");
                                files.add(new UploadFileInfoBean(file, "idImg", 0));
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
//                    show(e.getMessage());
                    }
                }

                if (facePicMedia != null) {
                    File file = new File(getLocalMediaPath(facePicMedia));
                    if (file.exists() && file.isFile())
                        files.add(new UploadFileInfoBean(file, "faceImg", 0));
                }
            }else { //绑定其他证件
                if (idPicMedia != null) {
                    File file = new File(getLocalMediaPath(idPicMedia));
                    if (file.exists() && file.isFile())
                        files.add(new UploadFileInfoBean(file, "certificatesImg", 0));
                }
            }
            if(files.size() > 0) {
                initPicUpload();
                uploadFiles(isBindOther);
            }else{
                uploadData(isBindOther);
            }
        }else{
            uploadData(isBindOther);
        }

    }

    private UploadManager uploadManager;
    private ProgressDialog progressDialog;
    private void initPicUpload(){
        Configuration config = new Configuration.Builder()
                .responseTimeout(60)
                .build();
        uploadManager = new UploadManager(config);
        progressDialog = new ProgressDialog(this,ProgressDialog.THEME_HOLO_LIGHT);
        progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        progressDialog.setTitle("上传图片");
        progressDialog.setMax(100);
        progressDialog.setProgress(0);
        progressDialog.show();
    }

    private void uploadFiles(boolean isBindOther){
        if(uploadManager != null){
            needUploadBean = null;
            //检测是否还有待上传的文件
            for(UploadFileInfoBean bean : files){
                if(bean.status == 0) {
                    needUploadBean = bean;
                    break;
                }
            }
            if(needUploadBean != null){ //上传图片
                String keyStr = "mctower_pic_" + System.currentTimeMillis() + "_" + new Random().nextInt(99999);
                String msg = "";
                switch (needUploadBean.type){
                    case "idImg":
                        msg = "正在上传身份证头像";
                        break;
                    case "faceImg":
                        msg = "正在上传面部照片";
                        break;
                    case "certificatesImg":
                        msg = "正在上传证件照片";
                        break;
                }
                progressDialog.setMessage(msg);
                uploadManager.put(needUploadBean.file, keyStr, qiNiuTokenBean.token,
                        (key, info, res) -> {
                            //res包含hash、key等信息，具体字段取决于上传策略的设置
                            if (info.isOK()) {
                                LogUtils.e("qiniu", "Upload Success");
                                needUploadBean.url = key;
                                needUploadBean.status = 1;
                                progressDialog.dismiss();
                            } else {
                                LogUtils.e("qiniu", "Upload Fail info=" + info + " res = " + res);
                                //如果失败，这里可以把info信息上报自己的服务器，便于后面分析上传错误原因
                                runOnUiThread(new Runnable() {
                                    public void run() {
                                        show("上传图片失败");
                                    }
                                });

                                needUploadBean.status = -1;
                                progressDialog.dismiss();
                            }
                            uploadFiles(isBindOther);
//                            LogUtils.e("qiniu", key + ",\r\n " + info + ",\r\n " + res);
                        }, new UploadOptions(null, null, false,
                                (key, percent) -> {
                                    progressDialog.setMax(100);
                                    progressDialog.setProgress((int) (percent * 100));
                                    LogUtils.e("qiniu", "key = " + key + ",percent = " + percent);
                                }, null));
            }else{ //图片都已上传过，提交数据到服务器
                for(UploadFileInfoBean bean : files){
                    if(bean.status == 1) {
                        switch (bean.type){
                            case "idImg":
                                identityImgUrl = bean.url;
                                break;
                            case "faceImg":
                                faceImgUrl = bean.url;
                                break;
                            case "certificatesImg":
                                certificatesImgUrl = bean.url;
                                break;
                        }
                    }
                }
                uploadData(isBindOther);
            }
        }

    }

    private void uploadData(boolean isBindOther){
        if(isBindOther){//绑定其他证件
            String code = otherIdInput.getText().toString();
            if(TextUtils.isEmpty(code)){
                ToastUtils.show("请输入证件号");
                return;
            }
            UploadBindOtherDataBean bean = new UploadBindOtherDataBean();
            bean.certificatesCode = code;

            if (!TextUtils.isEmpty(certificatesImgUrl))
                bean.certificatesImg = certificatesImgUrl;
            bean.uuid = id;
            HttpPostHelper.httpPutJson(this, Constant.API_SAVE_USER_INFO_OTHER, new DialogHttpCallBack(this) {

                @Override
                public void successCallBack(String result) {
                    super.successCallBack(result);
                    idNum.setText("证件号码："+code);
                    ToastUtils.show("操作成功");
                }
            }, new Gson().toJson(bean));
        }else {//绑定身份证
            UploadDataBean bean = new UploadDataBean();
            bean.identityCard = invsIdCard.getIdNo();
            if (!TextUtils.isEmpty(identityImgUrl))
                bean.identityImg = identityImgUrl;
            if (!TextUtils.isEmpty(faceImgUrl))
                bean.faceImg = faceImgUrl;
            bean.sex = invsIdCard.getSex1();
            bean.userName = invsIdCard.getName();
            bean.uuid = id;

            HttpPostHelper.httpPutJson(this, Constant.API_SAVE_USER_INFO, new DialogHttpCallBack(this) {

                @Override
                public void successCallBack(String result) {
                    super.successCallBack(result);
                    bindBtn.setText("更新");
                    idNoTitle.setVisibility(View.INVISIBLE);
                    idCode.setVisibility(View.INVISIBLE);
                    ToastUtils.show("操作成功");
                }
            }, new Gson().toJson(bean));
        }
    }

    /**
     * 从设备读取数据
     */
    private boolean startReadDeviceData = false;
    private void readDataFromDevice(){
        startReadDeviceData = true;
        if(countDownTimer != null)
            countDownTimer.cancel();

        countDownTimer = new CountDownTimer(3000,1000) {
            @Override
            public void onTick(long l) {
                /*invsIdCard in = new invsIdCard();
                in.setIdNo(String.valueOf(l));
                in.setSex1("男");
                in.setName("哈哈哈哈");
                showReadIdSuccessAlert(in);*/
            }

            @Override
            public void onFinish() {
                dismmisLoadingDialog();
                showReadIdAlert();
            }
        }.start();
        showLoadingDialog();

        /*if(idCard == null) {
            idCard = new IDCard(getApplicationContext(), new IDCardCallBack() {
                @Override
                public void idCardDeviceComment() {
                }

                @Override
                public void idCardDeviceUnComment() {
                }

                @Override
                public void readIDCardDataFail() {
                    //读卡器读取身份证信息失败
                    runOnUiThread(() -> {
                        showReadIdAlert();
                        dismmisLoadingDialog();
                    });
                    countDownTimer.cancel();
                }

                @Override
                public void readIDCardData(invsIdCard invsIdCard, boolean b) {
                    //读卡器读取身份证信息成功
                    runOnUiThread(() -> {
                        showReadIdSuccessAlert(invsIdCard);
                        dismmisLoadingDialog();
                    });
                    countDownTimer.cancel();

                }
            });
        }
*/

    }

    @OnClick({R.id.backBtn,R.id.otherBindBtn,R.id.otherIdPicture,R.id.uploadFacePicBtn,R.id.addFacePicTipFrame,R.id.bindBtn,
            R.id.cancelBtnInDialog,R.id.readSuccessDialogFrame,R.id.otherBindDialogFrame,R.id.saveNoteBtn,
            R.id.cancelBtn4OtherBind,R.id.bindBtn4OtherBind})
    public void click(View view){
        switch (view.getId()){
            case R.id.backBtn:
                onBackPressed();
                break;
            case R.id.otherBindBtn:
                otherBindDialogFrame.setVisibility(View.VISIBLE);
                break;
            case R.id.otherIdPicture:
                takePhoto(true);
                break;
            case R.id.uploadFacePicBtn:
            case R.id.addFacePicTipFrame:
                takePhoto(false);
                break;
            case R.id.bindBtn:
                readDataFromDevice();
                break;
            case R.id.readSuccessDialogFrame:
            case R.id.otherBindDialogFrame:
                break;
            case R.id.cancelBtnInDialog:
                readSuccessDialogFrame.setVisibility(View.GONE);
                break;
            case R.id.saveNoteBtn:
                saveNote();
                break;
            case R.id.cancelBtn4OtherBind:
                otherBindDialogFrame.setVisibility(View.GONE);
                break;
            case R.id.bindBtn4OtherBind:
                if(TextUtils.isEmpty(otherIdInput.getText().toString().trim())){
                    ToastUtils.show("请输入证件号");
                    break;
                }
                if(idPicMedia == null){
                    ToastUtils.show("请拍摄证件照");
                    break;
                }

                otherBindDialogFrame.setVisibility(View.GONE);
                uploadImages(true);
                break;
        }
    }

    private void saveNote(){
        String note = noteInput.getText().toString().trim();
        if(!TextUtils.isEmpty(note)){
            RemarkBean remarkBean= new RemarkBean();
            remarkBean.remark = note;
            remarkBean.userUuid = id;
            HttpPostHelper.httpPutJson(this,Constant.API_SAVE_NOTE,new DialogHttpCallBack(this){
                @Override
                public void successCallBack(String result) {
                    super.successCallBack(result);
                    ToastUtils.show("备注成功");
                }
            },remarkBean.toString());
        }
    }

    private void takePhoto(boolean isIDCard){
        isTakeIdPicNow = isIDCard;
        PictureSelector.create(this)
                .openCamera(PictureMimeType.ofImage())
                .theme(R.style.picture_default_style)
                .maxSelectNum(1)// 最大图片选择数量
                .minSelectNum(1)// 最小选择数量
                .imageSpanCount(4)// 每行显示个数
                .selectionMode(PictureConfig.SINGLE)// 多选 or 单选
                .previewImage(true)// 是否可预览图片
                .isCamera(true)// 是否显示拍照按钮
                .isZoomAnim(true)// 图片列表点击 缩放效果 默认true
                .enableCrop(false)// 是否裁剪
                .compress(true)// 是否压缩
                .synOrAsy(true)//同步true或异步false 压缩 默认同步
                .glideOverride(160, 160)// glide 加载宽高，越小图片列表越流畅，但会影响列表图片浏览的清晰度
                .freeStyleCropEnabled(true)// 裁剪框是否可拖拽
                .selectionMedia(mSelectList)// 是否传入已选图片
                .minimumCompressSize(100)// 小于100kb的图片不压缩
                .forResult(PictureConfig.CHOOSE_REQUEST);//结果回调onActivityResult code
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data == null) {
            return;
        }
        switch (requestCode) {
            case PictureConfig.CHOOSE_REQUEST:
                // 图片选择结果回调
                mSelectList = PictureSelector.obtainMultipleResult(data);
                if(mSelectList != null && mSelectList.size() > 0) {
                    LocalMedia media = mSelectList.get(0);
                    if (isTakeIdPicNow) {
                        idPicMedia = media;
                        otherIdPicture.setImageBitmap(BitmapFactory.decodeFile(getLocalMediaPath(idPicMedia)));
                        idPicture.setImageBitmap(BitmapFactory.decodeFile(getLocalMediaPath(idPicMedia)));
                        idPicture.setVisibility(View.VISIBLE);
                        addIDPicTipFrame.setVisibility(View.GONE);
                    } else {
                        facePicMedia = media;
                        facePicture.setImageBitmap(BitmapFactory.decodeFile(getLocalMediaPath(facePicMedia)));
                        facePicture.setVisibility(View.VISIBLE);
                        addFacePicTipFrame.setVisibility(View.GONE);
                    }
                }
                break;
        }
    }

    //获取LocalMedia的路径
    private String getLocalMediaPath(LocalMedia media){
        String path = "";
        if (media.isCut() && !media.isCompressed()) {
            // 裁剪过
            path = media.getCutPath();
        } else if (media.isCompressed() || (media.isCut() && media.isCompressed())) {
            // 压缩过,或者裁剪同时压缩过,以最终压缩过图片为准
            path = media.getCompressPath();
        } else {
            // 原图
            path = media.getPath();
        }
        return path;
    }


    @Override
    public void onBackPressed() {
        super.onBackPressed();
        /*if(idCard != null)
            idCard .unInit();*/
    }

    class MyAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder>{

        private LayoutInflater layoutInflater  = LayoutInflater.from(DetailActivity.this);

        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View itemView = layoutInflater.inflate(R.layout.itme_visit_record_log, parent, false);
            return new CustomViewHolder(itemView);
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            VisitRecordBean bean = data.get(position);
            CustomViewHolder viewHolder = (CustomViewHolder) holder;
            viewHolder.topDot1.setVisibility(position == 0 ? View.GONE : View.VISIBLE);
            viewHolder.topDot2.setVisibility(position == 0 ? View.GONE : View.VISIBLE);
            viewHolder.topLine1.setVisibility(position == 0 ? View.GONE : View.VISIBLE);
            viewHolder.topLine2.setVisibility(position == 0 ? View.GONE : View.VISIBLE);
            viewHolder.bottomDot1.setVisibility(position == data.size() - 1 ? View.GONE : View.VISIBLE);
            viewHolder.bottomDot2.setVisibility(position == data.size() - 1 ? View.GONE : View.VISIBLE);
            viewHolder.bottomLine1.setVisibility(position == data.size() - 1 ? View.GONE : View.VISIBLE);
            viewHolder.bottomLine2.setVisibility(position == data.size() - 1 ? View.GONE : View.VISIBLE);
            viewHolder.companyName.setText(bean.companyName);
            viewHolder.invatePerson.setText(bean.staffName);
            viewHolder.time.setText(bean.visitorTime);
            viewHolder.mobile.setText(bean.phone);
        }

        @Override
        public int getItemCount() {
            return data.size();
        }
    }

    public void readIdCardFailure(){
        if(startReadDeviceData) {
            runOnUiThread(() -> {
                showReadIdAlert();
                dismmisLoadingDialog();
            });
            if (countDownTimer != null)
                countDownTimer.cancel();
        }
    }

    public void setIdCardInfo(invsIdCard invsIdCard){
        if(startReadDeviceData) {
            runOnUiThread(() -> {
                showReadIdSuccessAlert(invsIdCard);
                dismmisLoadingDialog();
            });
            if (countDownTimer != null)
                countDownTimer.cancel();
        }

    }

    class CustomViewHolder extends RecyclerView.ViewHolder{

        private TextView companyName;
        private TextView invatePerson;
        private TextView time;
        private TextView mobile;
        private TextView topDot1;
        private TextView topLine1;
        private TextView topDot2;
        private TextView topLine2;
        private TextView bottomDot1;
        private TextView bottomDot2;
        private TextView bottomLine1;
        private TextView bottomLine2;

        public CustomViewHolder(@NonNull View itemView) {
            super(itemView);

            companyName = itemView.findViewById(R.id.companyName);
            invatePerson = itemView.findViewById(R.id.invatePerson);
            time = itemView.findViewById(R.id.time);
            mobile = itemView.findViewById(R.id.mobile);
            topDot1 = itemView.findViewById(R.id.topDot1);
            topLine1 = itemView.findViewById(R.id.topLine1);
            topDot2 = itemView.findViewById(R.id.topDot2);
            topLine2 = itemView.findViewById(R.id.topLine2);
            bottomDot1 = itemView.findViewById(R.id.bottomDot1);
            bottomDot2 = itemView.findViewById(R.id.bottomDot2);
            bottomLine1 = itemView.findViewById(R.id.bottomLine1);
            bottomLine2 = itemView.findViewById(R.id.bottomLine2);
        }
    }

    class UploadDataBean {
        public String faceImg;    //img",
        public String identityCard;    //4113*****",
        public String identityImg;    //img",
        public String sex;    //男女",
        public String userName;    //wjz",
        public String uuid;    //uuid"

    }

    class UploadFileInfoBean{
        public File file;
        public String type;
        public int status; // 0: 待上传  1：上传成功   -1：上传失败
        public String url;

        public UploadFileInfoBean(File file, String type, int stutas) {
            this.file = file;
            this.type = type;
            this.status = stutas;

        }
    }

    class UploadBindOtherDataBean{
        public String certificatesCode;
        public String certificatesImg;
        public String uuid;
    }

}
