package cn.dankal.base.utils;

import android.app.Activity;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.SystemClock;
import android.provider.MediaStore;
import android.text.ClipboardManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.webkit.WebView;

import com.lidroid.xutils.http.RequestParams;

import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;

import static android.content.Context.CLIPBOARD_SERVICE;

public class Utils {

	/**
	 * 获取本机mac
	 *
	 * @param context
	 * @return
	 */
	public static String getLocalMacAddress(Context context) {
		WifiManager wifi = (WifiManager) context
				.getSystemService(Context.WIFI_SERVICE);
		WifiInfo info = wifi.getConnectionInfo();
		return info.getMacAddress();
	}

	/**
	 * 加密
	 *
	 * @param str
	 * @return
	 */
	public static String MD5(String str) {
		MessageDigest md5 = null;
		try {
			md5 = MessageDigest.getInstance("MD5");
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}

		char[] charArray = str.toCharArray();
		byte[] byteArray = new byte[charArray.length];

		for (int i = 0; i < charArray.length; i++) {
			byteArray[i] = (byte) charArray[i];
		}
		byte[] md5Bytes = md5.digest(byteArray);

		StringBuffer hexValue = new StringBuffer();
		for (int i = 0; i < md5Bytes.length; i++) {
			int val = ((int) md5Bytes[i]) & 0xff;
			if (val < 16) {
				hexValue.append("0");
			}
			hexValue.append(Integer.toHexString(val));
		}
		return hexValue.toString();
	}

	/**
	 * 检测当的网络（WLAN、3G/2G）状态
	 *
	 * @param context
	 *            Context
	 * @return true 表示网络可用
	 */
	public static boolean isNetworkAvailable(Context context) {
		if(context == null)
			return false;
		ConnectivityManager connectivity = (ConnectivityManager) context
				.getSystemService(Context.CONNECTIVITY_SERVICE);
		if (connectivity != null) {
			NetworkInfo info = connectivity.getActiveNetworkInfo();
			if (info != null && info.isConnected()) {
				// 当前网络是连接的
				if (info.getState() == NetworkInfo.State.CONNECTED) {
					// 当前所连接的网络可用
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 检查SD卡是否存在
	 *
	 * @return
	 */
	public static boolean checkSDCard() {
		if (Environment.getExternalStorageState().equals(
				Environment.MEDIA_MOUNTED))
			return true;
		else
			return false;
	}

	/**
	 * 精确获取屏幕尺寸
	 *
	 * @param ctx
	 * @return
	 */
	public static DisplayMetrics getScreenPhysicalSize(Activity ctx) {
		DisplayMetrics dm = new DisplayMetrics();
		ctx.getWindowManager().getDefaultDisplay().getMetrics(dm);
		return dm;
	}

	/**
	 * 获取渠道信息
	 *
	 * @param context
	 * @return
	 */
	public static String getChannelCode(Context context) {
		String code = getMetaData(context, "UMENG_CHANNEL");
		if (code != null) {
			return code;
		}
		return "1_market";
	}

	/**
	 * 获取配置文件属性值
	 *
	 * @param context
	 * @param key
	 * @return
	 */
	private static String getMetaData(Context context, String key) {
		try {
			ApplicationInfo ai = context.getPackageManager()
					.getApplicationInfo(context.getPackageName(),
							PackageManager.GET_META_DATA);
			Object value = ai.metaData.get(key);
			if (value != null) {
				return value.toString();
			}
		} catch (Exception e) {
			//
		}
		return null;
	}

	/**
	 * 获取用户信息
	 *
	 * @param context
	 * @return
	 */
	public static HashMap<String, String> getDeviceInfo(Context context) {
		HashMap<String, String> map = new HashMap<String, String>();
//		android.telephony.TelephonyManager tm = (android.telephony.TelephonyManager) context
//				.getSystemService(Context.TELEPHONY_SERVICE);

		map.put("imei", getDeviceId(context)); // 手机辨识码
		// map.put("mob", tm.getLine1Number()); //手机号码，非登录APP号码
		map.put("os", "android"); // 操作系统
		String model = Build.MODEL; // 手机型号
		map.put("dev", model); // 设备名称
		String release = Build.VERSION.RELEASE; // android系统版本号
		map.put("osver", release); // app版本号
		map.put("chnl", getChannelCode(context)); // 渠道来源
		map.put("t", String.valueOf(SystemClock.currentThreadTimeMillis())); // 当前时间戳，从1970年1月1日0时开始到当前时间的毫秒数

		// LogUtils.e("json==========>", strJson);
		return map;
	}

	/**
	 * 获取用户信息
	 *
	 * @param context
	 * @param params
	 */
	public static void getDeviceInfo(Context context, RequestParams params) {
//		android.telephony.TelephonyManager tm = (android.telephony.TelephonyManager) context
//				.getSystemService(Context.TELEPHONY_SERVICE);

		params.addHeader("imei", getDeviceId(context)); // 手机辨识码
		// params.addHeader("mob", tm.getLine1Number()); //手机号码，非登录APP号码
		params.addHeader("os", "android"); // 操作系统
		String model = Build.MODEL; // 手机型号
		params.addHeader("dev", model); // 设备名称
		String release = Build.VERSION.RELEASE; // android系统版本号
		params.addHeader("osver", release);
		params.addHeader("chnl", getChannelCode(context)); // 渠道来源
		params.addHeader("t",
				String.valueOf(SystemClock.currentThreadTimeMillis())); // 当前时间戳，从1970年1月1日0时开始到当前时间的毫秒数
	}

	/**
	 * 获取设备标识
	 *
	 * @param context
	 * @return
	 */
	public static String getDeviceId(Context context) {
		android.telephony.TelephonyManager tm = (android.telephony.TelephonyManager) context
				.getSystemService(Context.TELEPHONY_SERVICE);
		String strId = "";
		if(ActivityCompat.checkSelfPermission(context, android.Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED){
			strId = android.provider.Settings.Secure.getString(
					context.getContentResolver(),
					android.provider.Settings.Secure.ANDROID_ID);
			if(TextUtils.isEmpty(strId))
				strId = getLocalMacAddress(context);
			return strId;
		}
		strId = tm.getDeviceId();
		// 如果为空，获取ANDROIDID
		if (TextUtils.isEmpty(strId)) {
			strId = android.provider.Settings.Secure.getString(
					context.getContentResolver(),
					android.provider.Settings.Secure.ANDROID_ID);
		}
		if(TextUtils.isEmpty(strId)) {
			strId = getLocalMacAddress(context);
		}
		return strId;
	}



	public static final String TAG = "Push";
	public static final String RESPONSE_METHOD = "method";
	public static final String RESPONSE_CONTENT = "content";
	public static final String RESPONSE_ERRCODE = "errcode";
	public static final String ACTION_MESSAGE = "com.baiud.pushdemo.action.MESSAGE";
	public static final String ACTION_RESPONSE = "bccsclient.action.RESPONSE";
	public static final String ACTION_SHOW_MESSAGE = "bccsclient.action.SHOW_MESSAGE";
	protected static final String EXTRA_ACCESS_TOKEN = "access_token";
	public static final String EXTRA_MESSAGE = "message";

	/**
	 * 获取AppKey
	 *
	 * @param context
	 * @param metaKey
	 * @return
	 */
	public static String getMetaValue(Context context, String metaKey) {
		Bundle metaData = null;
		String apiKey = null;
		if (context == null || metaKey == null) {
			return null;
		}
		try {
			ApplicationInfo ai = context.getPackageManager()
					.getApplicationInfo(context.getPackageName(),
							PackageManager.GET_META_DATA);
			if (null != ai) {
				metaData = ai.metaData;
			}
			if (null != metaData) {
				apiKey = metaData.getString(metaKey);
			}
		} catch (NameNotFoundException e) {

		}
		return apiKey;
	}

	/**
	 * 获取字符串长度
	 *
	 * @param value
	 * @return
	 */
	public static int length(String value) {
		int valueLength = 0;
		String chinese = "[\u4e00-\u9fa5]";
		// 获取字段值的长度，如果含中文字符，则每个中文字符长度为2，否则为1
		for (int i = 0; i < value.length(); i++) {
			// 获取一个字符
			String temp = value.substring(i, i + 1);
			// 判断是否为中文字符
			if (temp.matches(chinese)) {
				// 中文字符长度为1
				valueLength += 2;
			} else {
				// 其他字符长度为0.5
				valueLength += 1;
			}
		}
		return valueLength;
	}

	public static String getRootFilePath() {
		if (checkSDCard()) {
			return Environment.getExternalStorageDirectory().getAbsolutePath()
					+ "/dankal/";// filePath:/sdcard/
		} else {
			return Environment.getDataDirectory().getAbsolutePath()
					+ "/cn.dankal.shell/"; // filePath: /data/data/
		}
	}

	// 获取截图
	public static Bitmap convertViewToBitmap(View view) {
		view.setDrawingCacheEnabled(true);
		view.setDrawingCacheQuality(View.DRAWING_CACHE_QUALITY_HIGH);
		view.buildDrawingCache();
		Bitmap bitmap = view.getDrawingCache().copy(Config.RGB_565, false);
		return bitmap;
	}

	public static int compareVersion(String inVersion, String currentVertion) {
		String[] spritedInVersion = inVersion.split("\\.");
		String[] spritedCurrentVertion = currentVertion.split("\\.");
		if (spritedInVersion.length == spritedCurrentVertion.length) {
			int lenth = spritedInVersion.length;
			for (int i = 0; i < lenth; i++) {
				if (Integer.valueOf(spritedInVersion[i]).compareTo(
						Integer.valueOf(spritedCurrentVertion[i])) > 0) {
					return 1;
				} else if (Integer.valueOf(spritedInVersion[i]).compareTo(
						Integer.valueOf(spritedCurrentVertion[i])) < 0) {
					return -1;
				}
			}
		} else {
			int smallLenth = spritedInVersion.length < spritedCurrentVertion.length ? spritedInVersion.length
					: spritedCurrentVertion.length;
			for (int i = 0; i < smallLenth; i++) {
				if (Integer.valueOf(spritedInVersion[i]).compareTo(
						Integer.valueOf(spritedCurrentVertion[i])) > 0) {
					return 1;
				} else if (Integer.valueOf(spritedInVersion[i]).compareTo(
						Integer.valueOf(spritedCurrentVertion[i])) < 0) {
					return -1;
				}
			}
			if (spritedInVersion.length < spritedCurrentVertion.length) {
				return -1;
			} else {
				return 1;
			}
		}
		return 0;
	}

	/**
	 *  通过Uri获取真实文件路径
	 * @param activity
	 * @param contentUri
	 * @return
	 */
	public static String getRealPathFromURI(Activity activity, Uri contentUri) {
		String res = null;
		String[] proj = { MediaStore.Images.Media.DATA };
		Cursor cursor = activity.getContentResolver().query(contentUri, proj, null, null, null);
		if(cursor.moveToFirst()){;
			int column_index = cursor.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
			res = cursor.getString(column_index);
		}
		cursor.close();
		return res;
	}


	public static synchronized String getCurrentUserAgent(String str) {
		Locale locale = Locale.getDefault();
		StringBuffer buffer = new StringBuffer();
		// Add version
		final String version = Build.VERSION.RELEASE;
		if (version.length() > 0) {
			buffer.append(version);
		} else {
			// default to "1.0"
			buffer.append("1.0");
		}
		buffer.append("; ");
		final String language = locale.getLanguage();
		if (language != null) {
			buffer.append(language.toLowerCase());
			final String country = locale.getCountry();
			if (country != null) {
				buffer.append("-");
				buffer.append(country.toLowerCase());
			}
		} else {
			// default to "en"
			buffer.append("en");
		}
		// add the model for the release build
		if ("REL".equals(Build.VERSION.CODENAME)) {
			final String model = Build.MODEL;
			if (model.length() > 0) {
				buffer.append("; ");
				buffer.append(model);
			}
		}
		final String id = Build.ID;
		if (id.length() > 0) {
			buffer.append(" Build/");
			buffer.append(id);
		}
		return String.format(str, buffer);
	}

	public static String getDay(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date data = new Date();
		return sdf.format(data);

	}

	public static String getDayZn(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
		Date data = new Date();
		return sdf.format(data);

	}

	public static String getDay(long time){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date data = new Date(time);
		return sdf.format(data);

	}

	public static String getDaytime(long time){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		Date data = new Date(time);
		return sdf.format(data);

	}


	/**
	 * 获取app的版本名称
	 * @param context
	 * @return
	 */
	public static String getAppVersionName(Context context){
		PackageInfo packageInfo = getPackageInfo(context);
		if(packageInfo != null){
			return packageInfo.versionName;
		}else
			return null;
	}

	/**
	 * 获取app的版本编号
	 * @param context
	 * @return
	 */
	public static int getAppVersionCode(Context context){
		PackageInfo packageInfo = getPackageInfo(context);
		if(packageInfo != null){
			return packageInfo.versionCode;
		}else
			return 0;
	}

	private static PackageInfo getPackageInfo(Context context) {
		PackageInfo pi = null;
		try {
			PackageManager pm = context.getPackageManager();
			pi = pm.getPackageInfo(context.getPackageName(),0);
			return pi;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return pi;
	}


}
