package cn.dankal.base.utils;

import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import cn.mctower.visitor.MCTowerApplication;
import cn.mctower.visitor.R;


/**
 * Created by Alex Tang on 2016/12/29.
 */
public class ToastUtils {

    private static Toast mToast;


    public static void show(String message) {
        if(!TextUtils.isEmpty(message)) {
            mToast = new Toast(MCTowerApplication.getContext());
            LayoutInflater inflater = LayoutInflater.from(MCTowerApplication.getContext());
            View layout = inflater.inflate(R.layout.custom_toast, null);
            TextView msg = (TextView) layout.findViewById(R.id.msg);
            msg.setText(message);
            mToast = new Toast(MCTowerApplication.getContext());
            mToast.setGravity(Gravity.CENTER_HORIZONTAL | Gravity.BOTTOM, 0, UIUtil.Dp2Px(MCTowerApplication.getContext(), 60));
            mToast.setDuration(Toast.LENGTH_SHORT);
            mToast.setView(layout);
            mToast.show();
        }
    }

    public static void cancelToast() {
        if (mToast != null) {
            mToast.cancel();
        }
        
    }

    public static void show(int resourceId) {
        show(MCTowerApplication.getContext().getResources().getString(resourceId));
    }
}
