package cn.dankal.base.utils;

import android.text.TextUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class StringUtils {

	/**
	 * 将每三个数字加上逗号处理（通常使用金额方面的编辑）
	 * 
	 * @param str
	 *            无逗号的数字
	 * @return 加上逗号的数字
	 */
	public static String addComma(String str) {

		// 将传进数字反转
		String reverseStr = new StringBuilder(str).reverse().toString();

		String strTemp = "";
		for (int i = 0; i < reverseStr.length(); i++) {
			if (i * 3 + 3 > reverseStr.length()) {
				strTemp += reverseStr.substring(i * 3, reverseStr.length());
				break;
			}
			strTemp += reverseStr.substring(i * 3, i * 3 + 3) + ",";
		}
		// 将 【789,456,】 中最后一个【,】去除
		if (strTemp.endsWith(",")) {
			strTemp = strTemp.substring(0, strTemp.length() - 1);
		}

		// 将数字重新反转
		String resultStr = new StringBuilder(strTemp).reverse().toString();
		return resultStr;
	}

	/**
	 * 将带有分隔符的string装换为List<String>
	 * 
	 * @param str
	 * @param regularExpression
	 * @return
	 */
	public static List<String> string2List(String str, String regularExpression) {
		List<String> result = null;
		if (!TextUtils.isEmpty(str) && !TextUtils.isEmpty(regularExpression)) {
			String[] temp = str.split(regularExpression);
			if (temp != null) {
				result = new ArrayList<String>();
				for (String obj : temp) {
					result.add(obj);
				}
			}
		}
		return result;
	}

	/**
	 * 将List<String> 转换为已regularExpression为分隔符的String
	 * 
	 * @param regularExpression
	 * @return
	 */
	public static String list2String(List<String> data, String regularExpression) {
		String result = null;
		if (data != null && !TextUtils.isEmpty(regularExpression)) {
			StringBuffer buffer = new StringBuffer("");
			for (String temp : data) {
				if (buffer.toString().equals(""))
					buffer.append(temp);
				else
					buffer.append(regularExpression + temp);
			}
			result = buffer.toString();
		}
		return result;
	}

	public static String intToIp(int i) {
		return (i & 0xFF) + "." + ((i >> 8) & 0xFF) + "." + ((i >> 16) & 0xFF)
				+ "." + (i >> 24 & 0xFF);
	}

	/**
	 * 解析出url请求的路径，包括页面
	 * 
	 * @param strURL
	 *            url地址
	 * @return url路径
	 */
	public static String UrlPage(String strURL) {
		String strPage = null;
		String[] arrSplit = null;

		strURL = strURL.trim();

		arrSplit = strURL.split("[?]");
		if (strURL.length() > 0) {
			if (arrSplit.length > 1) {
				if (arrSplit[0] != null) {
					strPage = arrSplit[0];
				}
			}
		}

		return strPage;
	}

	/**
	 * 去掉url中的路径，留下请求参数部分
	 * 
	 * @param strURL url地址
	 * @return url请求参数部分
	 */
	private static String TruncateUrlPage(String strURL) {
		String strAllParam = null;
		String[] arrSplit = null;

		strURL = strURL.trim();

		arrSplit = strURL.split("[?]");
		if (strURL.length() > 1) {
			if (arrSplit.length > 1) {
				if (arrSplit[1] != null) {
					strAllParam = arrSplit[1];
				}
			}
		}

		return strAllParam;
	}

	/**
	 * 解析出url参数中的键值对 如 "index.jsp?Action=del&id=123"，解析出Action:del,id:123存入map中
	 * 
	 * @param url url地址
	 * @return url请求参数部分
	 */
	public static Map<String, String> URLRequest(String url) {
		Map<String, String> mapRequest = new HashMap<String, String>();

		String[] arrSplit = null;

		String strUrlParam = TruncateUrlPage(url);
		if (strUrlParam == null) {
			return mapRequest;
		}

		// 每个键值为一组 www.2cto.com
		arrSplit = strUrlParam.split("[&]");

		for (String strSplit : arrSplit) {

			String[] arrSplitEqual = null;
			arrSplitEqual = strSplit.split("[=]");

			// 解析出键值
			if (arrSplitEqual.length > 1) {
				// 正确解析
				mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);

			} else {
				if (arrSplitEqual[0] != "") {
					// 只有参数没有值，不加入
					mapRequest.put(arrSplitEqual[0], "");
				}
			}
		}
		return mapRequest;
	}
	
	/**
	 * 生成随机字符串
	 * @param length
	 * @return
	 */
	public static String getRandomString(int length) { //length表示生成字符串的长度
	    String base = "abcdefghijklmnopqrstuvwxyz0123456789";
	    Random random = new Random();
	    StringBuffer sb = new StringBuffer();
	    for (int i = 0; i < length; i++) {   
	        int number = random.nextInt(base.length());   
	        sb.append(base.charAt(number));   
	    }   
	    return sb.toString();   
	 }

	public static String getLimitString(String string , int length){
		if(string != null){
			if(string.length() <= length){
				return string;
			}else{
				return string.substring(0,15)+"....";
			}
		}else
			return null;
	}

	/**
	 * 将long转换为日期
	 * @param fromat
	 * @param millSec
	 * @return
	 */
	public static String longToData(String fromat, long millSec){
		SimpleDateFormat formatter = new SimpleDateFormat(fromat);
		Date date= new Date(millSec);
		return formatter.format(date);
	}

	/**
	 * double 转换为金额
	 * @param num
	 * @return
	 */
	public static String doubleToMoney(double num){
//		DecimalFormat df = new DecimalFormat("#.00");
		return String.format("%.2f", num);
	}


	public static HashMap<String, String> longToCountDownTime(long leftTimeSecond){
		HashMap<String, String> result = new HashMap<>();
		String second = String.valueOf(leftTimeSecond % 60);
		if(second.length() == 1){
			second = "0"+second;
		}
		result.put("second",second);
		String minute = String.valueOf(( leftTimeSecond/60 ) % 60);
		if(minute.length() == 1){
			minute = "0"+minute;
		}
		result.put("minute",minute);
		String hour = String.valueOf(leftTimeSecond / (60 * 60));
		if(hour.length() ==1){
			hour = "0"+hour;
		}
		result.put("hour",hour);
		return result;
	}
}
