package cn.dankal.base.utils;

import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;

import cn.mctower.visitor.MCTowerApplication;


public class SharedPreferenceHelper {

	public static final String TAG = SharedPreferenceHelper.class.getSimpleName();

	public static void saveSharedPreferences(String key, String value) {
		SharedPreferences mPre;
		SharedPreferences.Editor mEditor;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		mEditor = mPre.edit();
		mEditor.putString(key, value);
		mEditor.commit();
	}
	
	public static void saveSharedPreferencesLong(String key, long value) {
		SharedPreferences mPre;
		SharedPreferences.Editor mEditor;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		mEditor = mPre.edit();
		mEditor.putLong(key, value);
		mEditor.commit();
	}
	
	public static void saveSharedPreferencesInt(String key, int value) {
		SharedPreferences mPre;
		SharedPreferences.Editor mEditor;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		mEditor = mPre.edit();
		mEditor.putInt(key, value);
		mEditor.commit();
	}

	public static void saveSharedPreferences(String key, boolean value) {
		SharedPreferences mPre;
		SharedPreferences.Editor mEditor;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		mEditor = mPre.edit();
		mEditor.putBoolean(key, value);
		mEditor.commit();
	}

	public static String getSharedPreferences(String key) {
		SharedPreferences mPre;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		String value = mPre.getString(key, "");
		return value;
	}

	public static String getSharedPreferences(String key, String defValue) {
		SharedPreferences mPre;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		String value = mPre.getString(key, defValue);
		return value;
	}
	
	public static long getSharedPreferencesLong(String key) {
		SharedPreferences mPre;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		long value = mPre.getLong(key, 0);
		return value;
	}
	
	public static int getSharedPreferencesInt(String key) {
		SharedPreferences mPre;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		int value = mPre.getInt(key, 0);
		return value;
	}
	
	public static boolean getSharedPreferencesBoolean(String key) {
		SharedPreferences mPre;
		mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
				.getContext());
		return mPre.getBoolean(key, false);
	}

	/**
	 * 将对象保存在SharedPreferences中
	 * @param obj
	 * @param key
	 */
	public static void saveSharedPreferencesObject(Object obj , String key){
		if(obj == null){
			SharedPreferenceHelper.saveSharedPreferences(key,"");
		}else {
			try {
				// 保存对象
				SharedPreferences mPre;
				SharedPreferences.Editor mEditor;
				mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
						.getContext());
				mEditor = mPre.edit();
				//先将序列化结果写到byte缓存中，其实就分配一个内存空间
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				ObjectOutputStream os = new ObjectOutputStream(bos);
				//将对象序列化写入byte缓存
				os.writeObject(obj);
				//将序列化的数据转为16进制保存
				String bytesToHexString = bytesToHexString(bos.toByteArray());
				//保存该16进制数组
				mEditor.putString(key, bytesToHexString);
				mEditor.commit();
			} catch (IOException e) {
				e.printStackTrace();
				LogUtils.e(TAG, "保存obj失败");
			}
		}
	}

	/**
	 * 从SharedPreferences中获取对象
	 * @param key
	 * @return
	 */
	public static Object getSharedPreferencesObject(String key){
		try {
			SharedPreferences mPre;
			mPre = PreferenceManager.getDefaultSharedPreferences(MCTowerApplication
					.getContext());
			if (mPre.contains(key)) {
				String string = mPre.getString(key, "");
				if(TextUtils.isEmpty(string)){
					return null;
				}else{
					//将16进制的数据转为数组，准备反序列化
					byte[] stringToBytes = stringToBytes(string);
					ByteArrayInputStream bis=new ByteArrayInputStream(stringToBytes);
					ObjectInputStream is=new ObjectInputStream(bis);
					//返回反序列化得到的对象
					Object readObject = is.readObject();
					return readObject;
				}
			}
		} catch (StreamCorruptedException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		//所有异常返回null
		return null;
	}
	/*public static void setUserSharedPreferencesFile(Context context,String uid){
		File file = null;
		if(!TextUtils.isEmpty(uid)){
			file = new File(File.separator+"data"+File.separator+"data"+File.separator+context.getPackageName() +
				"shared_prefs"+File.separator+"com.geihui_preferences.xml");
		}else{
			file = new File(File.separator+"data"+File.separator+"data"+File.separator+context.getPackageName() +
					"shared_prefs"+File.separator+"uid_"+uid+".xml");
		}
		if(file.exists()){
			LogUtils.e("aaaaaaa", "fille exists");
		}
	}*/

	/**
	 * desc:将数组转为16进制
	 * @param bArray
	 * @return
	 * modified:
	 */
	public static String bytesToHexString(byte[] bArray) {
		if(bArray == null){
			return null;
		}
		if(bArray.length == 0){
			return "";
		}
		StringBuffer sb = new StringBuffer(bArray.length);
		String sTemp;
		for (int i = 0; i < bArray.length; i++) {
			sTemp = Integer.toHexString(0xFF & bArray[i]);
			if (sTemp.length() < 2)
				sb.append(0);
			sb.append(sTemp.toUpperCase());
		}
		return sb.toString();
	}

	/**
	 * desc:将16进制的数据转为数组
	 * <p>创建人：聂旭阳 , 2014-5-25 上午11:08:33</p>
	 * @param data
	 * @return
	 * modified:
	 */
	public static byte[] stringToBytes(String data){
		String hexString=data.toUpperCase().trim();
		if (hexString.length()%2!=0) {
			return null;
		}
		byte[] retData=new byte[hexString.length()/2];
		for(int i=0;i<hexString.length();i++)
		{
			int int_ch;  // 两位16进制数转化后的10进制数
			char hex_char1 = hexString.charAt(i); ////两位16进制数中的第一位(高位*16)
			int int_ch1;
			if(hex_char1 >= '0' && hex_char1 <='9')
				int_ch1 = (hex_char1-48)*16;   //// 0 的Ascll - 48
			else if(hex_char1 >= 'A' && hex_char1 <='F')
				int_ch1 = (hex_char1-55)*16; //// A 的Ascll - 65
			else
				return null;
			i++;
			char hex_char2 = hexString.charAt(i); ///两位16进制数中的第二位(低位)
			int int_ch2;
			if(hex_char2 >= '0' && hex_char2 <='9')
				int_ch2 = (hex_char2-48); //// 0 的Ascll - 48
			else if(hex_char2 >= 'A' && hex_char2 <='F')
				int_ch2 = hex_char2-55; //// A 的Ascll - 65
			else
				return null;
			int_ch = int_ch1+int_ch2;
			retData[i/2]=(byte) int_ch;//将转化后的数放入Byte里
		}
		return retData;
	}
}
