package cn.dankal.base.utils;

import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;

import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;

import cn.dankal.base.interfaces.INetPicInterface;
import cn.dankal.base.interfaces.INetPicLoadCallBack;

/**
 * Created by Alex Tang on 2016/4/19.
 */
public class NetPicUtil implements INetPicInterface {

    private DisplayImageOptions options;


    public NetPicUtil(){
        options = new DisplayImageOptions.Builder()
                .cacheInMemory(true)
                .cacheOnDisk(true)
                .considerExifParams(true)
                .bitmapConfig(Bitmap.Config.RGB_565)
                .build();
    }

    public NetPicUtil(int loadingPicResId, int emptyUrlPicResId, int loadFailPicResId){
        options = new DisplayImageOptions.Builder()
                .showImageOnLoading(loadingPicResId)
                .showImageForEmptyUri(emptyUrlPicResId)
                .showImageOnFail(loadFailPicResId)
                .cacheInMemory(true)
                .cacheOnDisk(true)
                .considerExifParams(true)
                .bitmapConfig(Bitmap.Config.RGB_565)
                .build();
    }

    @Override
    public void display(ImageView container, String url) {
        ImageLoader.getInstance().displayImage(url,container,options);
    }

    public void display(ImageView container, String url, final INetPicLoadCallBack callBack) {
        ImageLoader.getInstance().displayImage(url, container, new ImageLoadingListener() {
            @Override
            public void onLoadingStarted(String imageUri, View view) {

            }

            @Override
            public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                if(callBack != null)
                    callBack.onLoadFailed((ImageView)view,imageUri);
            }

            @Override
            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                if(callBack != null)
                    callBack.onLoadCompleted((ImageView)view,imageUri,loadedImage);
            }

            @Override
            public void onLoadingCancelled(String imageUri, View view) {

            }
        });
    }

    @Override
    public void displayLocalPic(ImageView container, String picPath) {
        ImageLoader.getInstance().displayImage(picPath,container);
    }

    public void setOptions(DisplayImageOptions option){
        options = option;
    }

    public void setDefaultPics(int loadingPicId,int emptyUriPicId,int loadFailurePicId){
        options = new DisplayImageOptions.Builder()
                .showImageOnLoading(loadingPicId)
                .showImageForEmptyUri(emptyUriPicId)
                .showImageOnFail(loadFailurePicId)
                .cacheInMemory(true)
                .cacheOnDisk(true)
                .considerExifParams(true)
                .bitmapConfig(Bitmap.Config.RGB_565)
                .build();
    }
}
