package cn.dankal.base.utils;

import android.util.Log;

import com.lidroid.xutils.http.RequestParams;
import com.socks.library.KLog;

import org.apache.http.NameValuePair;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

import cn.mctower.visitor.Constant;

public final class LogUtils {

    private static boolean sIsLogEnabled = true;// 是否打开LOG
//        private static boolean sIsLogEnabled = true;// 是否打开LOG
    private static String sApplicationTag = "com.mctower";// LOG默认TAG

    private static final String TAG_CONTENT_PRINT = "%s:%s.%s:%d";

    private static StackTraceElement getCurrentStackTraceElement() {
        return Thread.currentThread().getStackTrace()[4];

    }

    // 打印LOG
    public static void trace() {
        if (sIsLogEnabled) {
            KLog.d(getContent(getCurrentStackTraceElement()));
        }
    }

    // 获取LOG
    private static String getContent(StackTraceElement trace) {
        return String.format(TAG_CONTENT_PRINT, sApplicationTag,
                trace.getClassName(), trace.getMethodName(),
                trace.getLineNumber());
    }

    // 打印默认TAG的LOG
    public static void traceStack() {
        if (sIsLogEnabled) {
            traceStack(sApplicationTag, Log.ERROR);
        }
    }

    // 打印Log当前调用栈信�?
    public static void traceStack(String tag, int priority) {

        if (sIsLogEnabled) {
            StackTraceElement[] stackTrace = Thread.currentThread()
                    .getStackTrace();
            Log.println(priority, tag, stackTrace[4].toString());
            StringBuilder str = new StringBuilder();
            String prevClass = null;
            for (int i = 5; i < stackTrace.length; i++) {
                String className = stackTrace[i].getFileName();
                int idx = className.indexOf(".java");
                if (idx >= 0) {
                    className = className.substring(0, idx);
                }
                if (prevClass == null || !prevClass.equals(className)) {

                    str.append(className.substring(0, idx));

                }
                prevClass = className;
                str.append(".").append(stackTrace[i].getMethodName())
                        .append(":").append(stackTrace[i].getLineNumber())
                        .append("->");
            }
            Log.println(priority, tag, str.toString());
        }
    }

    // 指定TAG和指定内容的方法
    public static void d(String tag, String msg) {
        if (sIsLogEnabled) {
            KLog.d(tag, getContent(getCurrentStackTraceElement()) + ">" + msg);
        }
    }

    // 默认TAG和制定内容的方法
    public static void d(String msg) {
        if (sIsLogEnabled) {
            KLog.d(sApplicationTag, getContent(getCurrentStackTraceElement())
                    + ">" + msg);
        }
    }

    // 下面的定义和上面方法相同，可以定义不同等级的Debugger
    public static void i(String tag, String msg) {
        if (sIsLogEnabled) {
            KLog.i(tag, getContent(getCurrentStackTraceElement()) + ">" + msg);
        }
    }

    public static void w(String tag, String msg) {
        if (sIsLogEnabled) {
            KLog.w(tag, getContent(getCurrentStackTraceElement()) + ">" + msg);

        }
    }

    public static void v(String tag, String msg) {
        if (sIsLogEnabled) {
            KLog.v(tag, getContent(getCurrentStackTraceElement()) + ">" + msg);
        }
    }

    public static void e(String tag, String msg) {
        if (sIsLogEnabled) {
            KLog.e(tag, getContent(getCurrentStackTraceElement()) + ">" + msg);
        }
    }

    public static void r(String tag, String msg) {
        e(tag,msg);
        /*if (sIsLogEnabled) {
            Log.e(tag, getContent(getCurrentStackTraceElement()) + ">" + msg);
            saveToFile(tag + "-->" + getContent(getCurrentStackTraceElement()) + ">" + msg);
        }*/
    }


    public static void json(String tag, String json){
        if (sIsLogEnabled) {
            KLog.json(tag, json);
        }
    }

    public static void json(String json){
        if (sIsLogEnabled) {
            KLog.json(json);
        }
    }
}
