package cn.dankal.base.utils;

import android.content.Context;
import android.text.TextUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

import cn.mctower.visitor.Constant;


/**
 * Created by Alex Tang on 2015/12/15.
 */
public class FileUtils {

    public static final String TAG = FileUtils.class.getSimpleName();

    protected static final String mSdcardDataDir = Constant.BaseImagesDir;


    /**
     * 删除文件
     *
     * @param path
     */
    public static void deleteFile(String path) {
        File file = new File(path);
        if (file.exists())
            file.delete();
    }

    /**
     * 删除文件件夹
     * @param pPath
     */
    public static void deleteDir(final String pPath) {
        File dir = new File(pPath);
        deleteDirWihtFile(dir);
    }

    public static void deleteDirWihtFile(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory())
            return;
        if(dir.listFiles() == null)
            return;

        for (File file : dir.listFiles()) {
            if (file.isFile())
                file.delete(); // 删除所有文件
            else if (file.isDirectory())
                deleteDirWihtFile(file); // 递规的方式删除文件夹
        }
        dir.delete();// 删除目录本身
    }

    public static File copy(Context context, String fileName, String destPath) {
        try {
            InputStream is = context.getAssets().open(fileName);
            File file = new File(destPath);
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int len = 0;

            while ((len = is.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
            fos.close();
            is.close();
            return file;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }

    /**
     * 查找指定目录下的指定文件
     * @param dir
     * @param fileName
     * @return
     */
    public static File getFile(String dir, String fileName) {
        File fileDir = new File(dir);
        if (fileDir.isDirectory()) {
            File[] fileArray = fileDir.listFiles();
            if (null != fileArray && 0 != fileArray.length) {
                for (File file : fileArray) {
                    if (TextUtils.equals(fileName, file.getName())) {
                        return file;
                    }
                }
            }
        }
        return null;
    }


    public static long getDirectorySize(File directory){
        long size = 0;
        LogUtils.e("aaa","directory ="+directory.getAbsolutePath());
        File[] files = directory.listFiles();
        for(File file : files){
            if(file.isFile()){
                size += file.length();
                LogUtils.e("aaa","file ="+file.getAbsolutePath());
                LogUtils.e("aaa","file size = "+file.length());
            }else{
                size = getDirectorySize(file);
            }
        }
        return size;
    }

    /**
     * 获取目录长度
     *
     * @param dir 目录
     * @return 目录长度
     */
    public static long getDirLength(final File dir) {
        if (!isDir(dir)) return -1;
        long len = 0;
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    len += getDirLength(file);
                } else {
                    len += file.length();
                }
            }
        }
        return len;
    }

    /**
     * 判断是否是目录
     *
     * @param file 文件
     * @return {@code true}: 是<br>{@code false}: 否
     */
    public static boolean isDir(final File file) {
        return file != null && file.exists() && file.isDirectory();
    }

}
