package cn.dankal.base.interfaces;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;

/**
 * @类名: IBaseInterface
 * @功能描述: 界面通用接口类
 * @创建人： Alex
 * @创建时间: 2015-10-9 下午3:16:18
 */
public interface IBaseInterface {
	
	

	/**
	 * 显示Toast形式的提示信息
	 * 
	 * @param message
	 */
	public abstract void show(String message);

	/**
	 * 显示提示
	 * 
	 * @param resourceId
	 */
	public abstract void show(int resourceId);

	/**
	 * 根据id获取控件
	 * @param id
	 * @return
	 */
	public abstract <E extends View> E getView(int id);

	/**
	 * 跳转界面
	 * @param clazz
	 */
	public abstract void jumpActivity(Class<? extends Activity> clazz, boolean needLogin);

	/**
	 * 跳转界面
	 * @param clazz
	 * @param flag
	 */
	public abstract void jumpActivity(Class<? extends Activity> clazz, int flag, boolean needLogin);

	/**
	 * 跳转界面
	 * @param clazz
	 * @param requestCode
	 */
	public abstract void jumpActivityForResult(Class<? extends Activity> clazz,
                                               int requestCode, boolean needLogin);

	/**
	 * 跳转界面
	 * @param clazz
	 * @param data
	 * @param requestCode
	 */
	public void jumpActivityForResult(Class<? extends Activity> clazz, Bundle data,
                                      int requestCode, boolean needLogin);
	/**
	 * 跳转界面
	 * @param clazz
	 * @param data
	 */
	public abstract void jumpActivity(Class<? extends Activity> clazz,
                                      Bundle data, boolean needLogin);

	/**
	 * 跳转界面
	 * @param clazz
	 * @param data
	 * @param flag
	 */
	public abstract void jumpActivity(Class<? extends Activity> clazz,
                                      Bundle data, int flag, boolean needLogin);

	/**
	 * 跳转界面
	 * @param intent
	 */
	public abstract void jumpActivity(Intent intent, boolean needLogin);

	/**
	 * 是否登录了
	 * @return
	 */
	boolean isLogined();


}