package cn.dankal.base.http;

import android.text.TextUtils;

import com.google.gson.Gson;

import org.json.JSONException;
import org.json.JSONObject;

import cn.dankal.base.interfaces.IHttpCallBack;
import cn.dankal.base.utils.LogUtils;


public class NOToastHttpCallBack implements IHttpCallBack {

	public static final String TAG = NOToastHttpCallBack.class.getSimpleName();

	private boolean needLoginWithLocaldata = true;

	public NOToastHttpCallBack(){

	}

	public NOToastHttpCallBack(boolean needLoginWithLocaldata){
		this.needLoginWithLocaldata = needLoginWithLocaldata;
	}

	@Override
	public void requestStart() {
	}

	/**
	 * 请求成功，如果服务器返回状态为1时，会对用户的基本信息进行本地保存
	 * @param result
	 */
	@Override
	public void requestSuccess(String result) {
		successCallBack(result);
	}

	/**
	 * 当服务器返回状态为0时调用该接口
	 * @param result
	 */
	@Override
	public void requestFailure(String code, String result) {
		LogUtils.e("请求失败", result);
	}

	@Override
	public void requestOffLine() {

	}

	@Override
	public void requestFinish() {
	}

	/**
	 * 当服务器返回状态为1时调用该接口返回data属性的string内容
	 * @param result
	 */
	@Override
	public void successCallBack(String result) {

	}

	@Override
	public void downLoadSuccess(String result) {

	}

	@Override
	public void downLoadFailure(String result) {

	}

	@Override
	public void saveUserVarsData(String varsJson) {
		LogUtils.e("AAAA","**** saveUserVarsData");
		Gson gson = new Gson();

	}

}
