package cn.dankal.base.http;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.widget.Toast;


import com.google.gson.Gson;
import com.lidroid.xutils.HttpUtils;
import com.lidroid.xutils.exception.HttpException;
import com.lidroid.xutils.http.RequestParams;
import com.lidroid.xutils.http.ResponseInfo;
import com.lidroid.xutils.http.callback.RequestCallBack;
import com.lidroid.xutils.http.client.HttpRequest;
import com.socks.library.KLog;

import org.apache.http.entity.StringEntity;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.dankal.base.interfaces.IHttpCallBack;
import cn.dankal.base.interfaces.IHttpPostFileCallBack;
import cn.dankal.base.utils.LogUtils;
import cn.dankal.base.utils.StringUtils;
import cn.dankal.base.utils.ToastUtils;
import cn.dankal.base.utils.Utils;


public class HttpPostHelper {

    public static final String TAG = HttpPostHelper.class.getSimpleName();

    public static void httpGet(final Context context, final String url,
                               final IHttpCallBack callback, final HashMap<String, String> map) {
        if (!Utils.isNetworkAvailable(context)) {
            Toast.makeText(context, "请打开网络！", Toast.LENGTH_LONG).show();
            callback.requestOffLine();
            return;
        }
        String str = getURLAndParameter(url, map);
        LogUtils.e("url", str);

        RequestParams params = new RequestParams();
        if(map != null)
            for (String strKey : map.keySet()) {
//                params.addBodyParameter(strKey, map.get(strKey));
                params.addQueryStringParameter(strKey,map.get(strKey));
            }

        HttpUtils http = new HttpUtils();
        http.configCurrentHttpCacheExpiry(100);
        http.send(HttpRequest.HttpMethod.GET, url, params,
                new RequestCallBack<String>() {

                    @Override
                    public void onStart() {
                        callback.requestStart();
                    }

                    @Override
                    public void onSuccess(ResponseInfo<String> responseInfo) {
                        LogUtils.e("result", responseInfo.result);
                        callback.requestSuccess(responseInfo.result);
                        callback.requestFinish();
//                        saveCookie(responseInfo.getAllHeaders());
                    }

                    @Override
                    public void onFailure(HttpException error, String msg) {
                        LogUtils.e("请求失败:", msg);
                        callback.requestFailure("-3",msg);
                        callback.requestFinish();
                    }
                });
    }

    public static void httpPutJson(final Context context, final String url,
                                   final IHttpCallBack callback, final String json) {
        if (!Utils.isNetworkAvailable(context)) {
            Toast.makeText(context, "请打开网络！", Toast.LENGTH_LONG).show();
            callback.requestOffLine();
            return;
        }
        String str = getURLAndParameter(url, null);

        RequestParams params = new RequestParams();
        params.setContentType("application/json");
        try {
            if(!TextUtils.isEmpty(json))
                params.setBodyEntity(new StringEntity(json, "UTF-8"));
            HttpUtils http = new HttpUtils();
            http.send(HttpRequest.HttpMethod.PUT, url, params,
                    new RequestCallBack<String>() {

                        @Override
                        public void onStart() {
                            callback.requestStart();
                        }

                        @Override
                        public void onSuccess(ResponseInfo<String> responseInfo) {
                            LogUtils.e("result", responseInfo.result);
                            callback.requestSuccess(responseInfo.result);
                            callback.requestFinish();
                        }

                        @Override
                        public void onFailure(HttpException error, String msg) {
                            LogUtils.e("请求失败:", "error : " +msg + error.getLocalizedMessage());
                            callback.requestFailure("-3",msg);
                            callback.requestFinish();
                        }
                    });
            LogUtils.e("url", str);
            LogUtils.e("body", json);
        }catch (Exception e){
            e.printStackTrace();
        }

    }

    public static void httpPost(final Context context, final String url,
                                final IHttpCallBack callback, HashMap<String, String> map, int retryTimes) {
        if (!Utils.isNetworkAvailable(context)) {
            LogUtils.e(TAG, "isNetworkAvailable = false");
            ToastUtils.show("您的设备目前没有连接网络！");
//            ToastUtils.show("您的设备目前没有连接网络！");
            callback.requestOffLine();
            callback.requestFailure("-2","网络连接失败，请查看网络连接");
            KLog.e("HttpPost***url=" + url + "\n" + "请求失败：网络连接失败，请查看网络连接");
            callback.requestFinish();
            return;
        }

        //参加参数
        RequestParams params = new RequestParams();
        HashMap<String, String> allParams = createAllParams(context, map);
        for (String strKey : allParams.keySet()) {
            //添加普通参数
            params.addBodyParameter(strKey, allParams.get(strKey));
            params.addQueryStringParameter(strKey,allParams.get(strKey));
//			LogUtils.e(TAG,"["+strKey+","+allParams.get(strKey)+"]");
        }
//        params.setHeader("X-Access-Token","d7d3353c3c54fe8383b584a165e65e12");
        //获得完整的访问Url
        String str = getURLAndParameter(url, allParams);
        LogUtils.e("url", "HttpPostRequest*** url ="+str);
        final String urlLog = str;
        final HttpUtils http = new HttpUtils();
        http.configDefaultHttpCacheExpiry(30 * 1000);
        if(retryTimes > 0)
            http.configRequestRetryCount(retryTimes);
        http.configRequestThreadPoolSize(5);
        LogUtils.e(TAG,"REQUEST URL = "+url);
        http.send(HttpRequest.HttpMethod.POST, url, params,
                new RequestCallBack<String>() {

                    @Override
                    public void onStart() {
                        KLog.e("HttpPostRequest*** 开始请求["+ System.currentTimeMillis()+"] url=" + url);
                        callback.requestStart();
                    }

                    @Override
                    public void onSuccess(ResponseInfo<String> responseInfo) {
                        String result = responseInfo.result;
                        KLog.e("HttpPostRequest*** 请求成功[" + System.currentTimeMillis() + "] url=" + url + "--" + "：结果：【size=" + result.length() + "】" + result);
                        callback.requestSuccess(result);
                        callback.requestFinish();
                    }


                    @Override
                    public void onFailure(HttpException error, String msg) {
                        KLog.e("HttpPostRequest*** 请求失败["+ System.currentTimeMillis()+"] url=" + url + "--" + "错误信息："+msg);
                        callback.requestFailure("-3",msg);
                        callback.requestFinish();
                    }
                });
    }


    public static void httpPostFiles(final Context context, final String url, final IHttpPostFileCallBack callback , ArrayList<File> files, HashMap<String,String> para){
        if (!Utils.isNetworkAvailable(context)) {
            LogUtils.e(TAG, "isNetworkAvailable = false");
            Toast.makeText(context,"您的设备目前没有连接网络！", Toast.LENGTH_SHORT).show();
//            ToastUtils.show("您的设备目前没有连接网络！");
            callback.requestOffLine();
            callback.requestFailure("网络连接失败，请查看网络连接");
            KLog.e("HttpPost***url=" + url + "\n" + "请求失败：网络连接失败，请查看网络连接");
            callback.requestFinish();
            return;
        }

        RequestParams params = new RequestParams();
        if(files != null) {
            int i = 0;
            for (File file : files) {
                if (file.exists()) {
                    i ++;
                    params.addBodyParameter("img"+i, file, "image/jpg");
                    LogUtils.e("111","img"+i+":"+file.getPath()+"/"+file.getName());
                }
            }
        }

        HashMap<String, String> allParams = createAllParams(context, para);
        for (String strKey : allParams.keySet()) {
            //添加普通参数
            params.addBodyParameter(strKey, allParams.get(strKey));
        }

        //获得完整的访问Url
        String str = getURLAndParameter(url, allParams);
        LogUtils.e("url", "HttpPostRequest*** url ="+str);
        HttpUtils http = new HttpUtils();
        http.configRequestThreadPoolSize(5);

        http.send(HttpRequest.HttpMethod.POST, url, params, new RequestCallBack<String>() {
            @Override
            public void onCancelled() {
                if(callback != null)
                    callback.onCancle();
            }

            @Override
            public void onStart() {
                KLog.e("HttpPostRequest*** 开始请求["+ System.currentTimeMillis()+"] url=" + url);
                if(callback != null)
                    callback.requestStart();
            }
            @Override
            public void onLoading(long total, long current, boolean isUploading) {
                KLog.e("HttpPostRequest*** onLoading ["+ System.currentTimeMillis()+"] url=" + url + "--" + "进度："+total+"/"+current);
                //这里可以增加loading，或进度条开始
                if(callback != null)
                    callback.onLoading(total,current);
            }
            @Override
            public void onFailure(HttpException arg0, String arg1) {
                KLog.e("HttpPostRequest*** 请求失败["+ System.currentTimeMillis()+"] url=" + url + "--" + "错误信息："+arg1);
                //请求失败，可做异常提示处理和loading、进度条消失
                if(callback != null)
                    callback.requestFailure(arg1);
            }

            @Override
            public void onSuccess(ResponseInfo<String> responseInfo) {
                KLog.e("HttpPostRequest*** 请求成功["+ System.currentTimeMillis()+"] url=" + url + "--" + "：结果：【size="+responseInfo.result.length()+"】"+responseInfo.result);
                //请求成功，做相应处理和loading、进度条消失
                if(callback != null) {
                    callback.successCallBack(responseInfo.result);
                }
            }
        });
    }

    public static void httpPost(final Context context, String url,
                                final IHttpCallBack callback, HashMap<String, String> map) {
        httpPost(context, url, callback, map, 0);
    }



    /* *//**
     *
     * @param context
     * @param url
     * @param callback
     *//*

    public static void downLoad(final Context context, String url, final IHttpCallBack callback) {

        if (!Utils.isNetworkAvailable(context)) {
            Toast.makeText(context, "请打开网络！", Toast.LENGTH_LONG).show();
            callback.requestOffLine();
            return;
        }
        //获得app名称
        int m = url.lastIndexOf("/");
        int n = url.length();
        if (url.toLowerCase().endsWith(".apk")) {
            n = url.length();
        } else {
            n = url.toLowerCase().lastIndexOf(".apk?") + 4;
        }
        String str = url.substring(m + 1, n);
        LogUtils.e("apk下载地址", "apk名称: " + str);
        String downLoadPath = Constant.BaseImagesDir + str;

        HttpUtils http = new HttpUtils();
        http.configDefaultHttpCacheExpiry(30 * 1000);
        http.download(url, downLoadPath, false, false, new RequestCallBack<File>() {
            @Override
            public void onStart() {
                callback.requestStart();
            }

            @Override
            public void onLoading(long total, long current, boolean isUploading) {
                super.onLoading(total, current, isUploading);
            }

            @Override
            public void onSuccess(ResponseInfo<File> responseInfo) {
                callback.downLoadSuccess(responseInfo.result.getPath());
            }

            @Override
            public void onFailure(HttpException e, String s) {
                callback.downLoadFailure(s);

            }
        });
    }
*/

    public static void httpPostWithoutCommonParams(final Context context, String url,
                                                   final IHttpCallBack callback, HashMap<String, String> map) {
        if (!Utils.isNetworkAvailable(context)) {
            Toast.makeText(context, "请打开网络！", Toast.LENGTH_LONG).show();
            callback.requestOffLine();
            return;
        }
        RequestParams params = new RequestParams();
        if(map != null && map.size() > 0)
            for (String strKey : map.keySet()) {
                params.addBodyParameter(strKey, map.get(strKey));
            }
        final HttpUtils http = new HttpUtils();
        http.configDefaultHttpCacheExpiry(30 * 1000);

        http.send(HttpRequest.HttpMethod.POST, url, params,
                new RequestCallBack<String>() {

                    @Override
                    public void onStart() {
                        callback.requestStart();
                    }

                    @Override
                    public void onSuccess(ResponseInfo<String> responseInfo) {
                        LogUtils.e("result", responseInfo.result);
                        callback.requestSuccess(responseInfo.result);
                        callback.requestFinish();
                    }

                    @Override
                    public void onFailure(HttpException error, String msg) {
                        LogUtils.e("请求失败:", msg);
                        callback.requestFailure("-3","请求失败！");
                        callback.requestFinish();
                    }
                });
    }


    public static void httpGetWithoutCommonParams(final Context context, String url,
                                                  final IHttpCallBack callback) {
        if (!Utils.isNetworkAvailable(context)) {
            return;
        }

        final HttpUtils http = new HttpUtils();
        http.configDefaultHttpCacheExpiry(30 * 1000);

        http.send(HttpRequest.HttpMethod.GET, url, null,
                new RequestCallBack<String>() {

                    @Override
                    public void onStart() {
                        callback.requestStart();
                    }

                    @Override
                    public void onSuccess(ResponseInfo<String> responseInfo) {
                        LogUtils.e("result", responseInfo.result);
                        callback.requestSuccess(responseInfo.result);
                        callback.requestFinish();
                    }

                    @Override
                    public void onFailure(HttpException error, String msg) {
                        LogUtils.e("请求失败:", msg);
                        callback.requestFailure("-3","请求失败！");
                        callback.requestFinish();
                    }
                });
    }


    public static String getURLAndParameter(String url, HashMap<String, String> map) {
        if (TextUtils.isEmpty(url))
            return "";
        if(map == null || map.isEmpty())
            return url;
        StringBuilder encodedParams = new StringBuilder(url);
        if (map.entrySet().size() > 0) {
            if (url.contains("?"))
                encodedParams.append('&');
            else
                encodedParams.append('?');
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Map<String, String> pramas = StringUtils.URLRequest(url);
            if (!pramas.containsKey(entry.getKey())) {
                encodedParams.append(entry.getKey());
                encodedParams.append('=');
                encodedParams.append(entry.getValue());
                encodedParams.append('&');
            }
        }
        if (map.entrySet().size() > 0)
            encodedParams.deleteCharAt(encodedParams.length() - 1);
        String strUrl = encodedParams.toString();
        return strUrl;
    }


    /**
     * 获取网络请求通用参数
     *
     * @param context
     * @return
     */
    private static HashMap<String, String> getCommonParams(Context context) {
        HashMap<String, String> map = new HashMap<String, String>();
        /*map.put("imei", Utils.getDeviceId(context)); // 手机辨识码
        map.put("os", "android"); // 操作系统
		String model = Build.MODEL; // 手机型号
		map.put("dev", model); // 设备名称
		String release = Build.VERSION.RELEASE; // android系统版本号
		map.put("osver", release);
		map.put("ver", Constant.vsn); // app版本号
		map.put("chnl", Utils.getChannelCode(context)); // 渠道来源*/

        /*map.put("geihui_timestamp", String.valueOf(Calendar.getInstance().getTimeInMillis())); // 当前时间戳，从1970年1月1日0时开始到当前时间的毫秒数
        map.put("geihui_app", "1");
        map.put("device_type", "app");
        UserInfoBean userInfoBean = GotGoodBargainApplication.getUserInfo();
        if(userInfoBean != null && !TextUtils.isEmpty(userInfoBean.token)){
            map.put("token",userInfoBean.token);
        }*/
        map.put("app_type", "2");
        map.put("system_version",  Build.VERSION.RELEASE);
        map.put("device_id", Utils.getDeviceId(context));
        map.put("model", Build.MANUFACTURER+"-"+ Build.MODEL);

        return map;
    }

    public static HashMap<String, String> createAllParams(Context context, HashMap<String, String> normalParams) {
        HashMap<String, String> allParams = new HashMap<String, String>();
        if (normalParams != null)
            //添加普通参数
            allParams.putAll(normalParams);
        //添加必要参数
        allParams.putAll(getCommonParams(context));

        //参数排序
        List<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(allParams.entrySet());

        Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>() {
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });

        //拼接参数
        StringBuffer signStr = new StringBuffer("");
        for (Map.Entry<String, String> mapping : infoIds) {
            signStr.append(mapping.getKey() + mapping.getValue());
        }

        return allParams;
    }

    public static String toMd5(String str) {
        return toMd5(str.getBytes());
    }

    public static String toMd5(byte[] bytes) {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(bytes);
            return toHexString(algorithm.digest(), "");
        } catch (NoSuchAlgorithmException e) {
            // Log.v("he--------------------------------ji", "toMd5(): " + e);
            // throw new RuntimeException(e);
            // 05-20 09:42:13.697: ERROR/hjhjh(256):
            // 5d5c87e61211ab7a4847f7408f48ac
        }

        return null;

    }

    public static String toHexString(byte[] bytes, String separator) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex).append(separator);
        }
        return hexString.toString();
    }

}
