package cn.dankal.base.http;

import android.text.TextUtils;
import android.widget.Toast;

import org.json.JSONException;
import org.json.JSONObject;

import cn.dankal.base.interfaces.IHttpCallBack;
import cn.dankal.base.utils.LogUtils;
import cn.mctower.visitor.MCTowerApplication;

public class HttpCallBack implements IHttpCallBack {

	@Override
	public void requestStart() {
	}

	/**
	 * 请求成功，如果服务器返回状态为1时，会对用户的基本信息进行本地保存
	 * @param result
	 */
	@Override
	public void requestSuccess(String result) {
		String msg;
		try {
			JSONObject obj = new JSONObject(result);
			int status = obj.optInt("status", 0);
			if (status == 200) {
				String data = obj.optString("data");
				String vars = obj.optString("vars");
				if(!TextUtils.isEmpty(vars)){
					saveUserVarsData(vars);
				}
				data = data.replace("\"page\":[]","\"page\":{}");
				data = data.replace("\"page\":\"\"","\"page\":{}");
				data = data.replace("\"last_time\":[]","\"last_time\":{}");
				successCallBack(data);
			} else {
				msg = obj.optString("info", "服务器繁忙，请稍后再试！");
				requestFailure(String.valueOf(status),msg);
			}
		} catch (JSONException e) {
			msg = "服务器返回数据出错！";
			requestFailure("-1",msg);//app数据解析错误
			LogUtils.e("解析失败", e.getMessage());
		}
	}

	/**
	 * 当服务器返回状态为0时调用该接口
	 * @param result
	 */
	@Override
	public void requestFailure(String code, String result) {
		Toast.makeText(MCTowerApplication.getContext(), result, Toast.LENGTH_SHORT).show();
	}

	@Override
	public void requestOffLine() {

	}

	@Override
	public void requestFinish() {
	}

	/**
	 * 当服务器返回状态为1时调用该接口返回data属性的string内容
	 * @param result
	 */
	@Override
	public void successCallBack(String result) {

	}

	@Override
	public void downLoadSuccess(String result) {

	}

	@Override
	public void downLoadFailure(String result) {

	}

	@Override
	public void saveUserVarsData(String varsJson) {

	}

}
