package cn.dankal.base.http;

import android.app.Dialog;
import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

import cn.dankal.base.activity.NetBaseAppCompatActivity;
import cn.dankal.base.interfaces.IHttpCallBack;
import cn.dankal.base.interfaces.INetBaseInterface;
import cn.dankal.base.utils.LogUtils;


public class DialogHttpCallBack implements IHttpCallBack {

	/**
	 * 操作提示Dialog
	 */
	private Dialog mAlertDialog;
	private INetBaseInterface activity;
	public String msg = "";
	public boolean showInfoWhenRequestSuccess = true;

	public DialogHttpCallBack(INetBaseInterface activity) {
		this.activity = activity;
		this.mAlertDialog = activity.createDialog();
	}

	public DialogHttpCallBack(INetBaseInterface activity,boolean autoShowInfo) {
		this(activity);
		showInfoWhenRequestSuccess = autoShowInfo;
	}

	@Override
	public void requestStart() {
		if (mAlertDialog == null) {
			mAlertDialog = activity.createDialog();
		}
		if(activity != null){
			if(activity instanceof NetBaseAppCompatActivity){
				if(((NetBaseAppCompatActivity)activity).isFinishing()){
					return;
				}else{
					mAlertDialog.show();
				}
			}else
				return;
		}
	}


	/**
	 * 请求成功，如果服务器返回状态为1时，会对用户的基本信息进行本地保存
	 * @param result
	 */
	@Override
	public void requestSuccess(String result) {
		successCallBack(result);
	}

	/**
	 * 当服务器返回状态为0时调用该接口
	 * @param result
	 */
	@Override
	public void requestFailure(String code, String result) {
			activity.show(result);
	}

	@Override
	public void requestOffLine() {

	}

	@Override
	public void requestFinish() {
		if (mAlertDialog != null && mAlertDialog.isShowing()) {
			mAlertDialog.cancel();
		}
	}

	/**
	 * 当服务器返回状态为1时调用该接口返回data属性的string内容
	 * @param result
	 */
	@Override
	public void successCallBack(String result) {

	}

	@Override
	public void downLoadSuccess(String result) {

	}

	@Override
	public void downLoadFailure(String result) {

	}

	@Override
	public void saveUserVarsData(String varsJson) {

	}

	public String getInfo(){
		return msg;
	}
}
