package cn.dankal.base.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import cn.dankal.base.utils.UIUtil;
import cn.mctower.visitor.R;


public class BaseLoadingDialog extends Dialog {

	public BaseLoadingDialog(Context context, int theme) {
		super(context, theme);
		View view = LayoutInflater.from(context).inflate(
				R.layout.base_dialog_circle, null);
		//设定布局
		this.getWindow().setGravity(Gravity.CENTER);
		this.getWindow().setLayout(UIUtil.Dp2Px(context,60),UIUtil.Dp2Px(context,60));
		this.getWindow().setContentView(view);
		this.setCanceledOnTouchOutside(false);
	}
	
	@Override
	public void onBackPressed() {
		//进度条显示时不允许后退
		if(this.isShowing())
			return;
		else
			super.onBackPressed();
	}

}
