package cn.dankal.base.activity;

import android.app.ActionBar;
import android.app.Dialog;

import cn.dankal.base.dialog.BaseLoadingDialog;
import cn.dankal.base.interfaces.INetBaseInterface;
import cn.mctower.visitor.R;

/**
 * @类名: NetBaseActivity
 * @功能描述: 网络基础Activity
 * @创建人： Alex
 */
public class NetBaseAppCompatActivity extends BaseAppCompatActivity implements INetBaseInterface {


	public static final String TAG = "NetBaseAppCompatActivity";
	/**
	 * 操作提示Dialog
	 */
	protected String title = "";
	protected ActionBar actionBar;
	public Dialog mAlertDialog;


	@Override
	public Dialog createDialog() {
		if (mAlertDialog == null)
			mAlertDialog = new BaseLoadingDialog(this, R.style.basedDialogStyle);
		return mAlertDialog;
	}


    @Override
	protected void onDestroy() {
		if (mAlertDialog != null && mAlertDialog.isShowing()) {
			mAlertDialog.dismiss();
		}
		super.onDestroy();
	}

	/**
	 * 显示加载动画
	 */
	public void showLoadingDialog(){
		createDialog();
		mAlertDialog.show();
	}

	/**
	 * 关闭加载动画
	 */
	public void dismmisLoadingDialog(){
		if(mAlertDialog != null && mAlertDialog.isShowing())
			mAlertDialog.dismiss();
	}




}
