package cn.dankal.base.activity;


import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;


import java.util.List;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import cn.dankal.base.interfaces.IBaseInterface;
import cn.dankal.base.interfaces.IHotpicJumpCallBack;
import cn.dankal.base.interfaces.IPermissionCheck;
import cn.dankal.base.utils.LogUtils;
import cn.dankal.base.utils.ToastUtils;
import cn.dankal.base.utils.Utils;
import pub.devrel.easypermissions.AppSettingsDialog;
import pub.devrel.easypermissions.EasyPermissions;

/**
 * @类名: BaseActivity
 * @功能描述: 基础Activity
 * @创建人： Alex
 */
public class BaseAppCompatActivity extends AppCompatActivity implements
        IBaseInterface,IHotpicJumpCallBack,
        EasyPermissions.PermissionCallbacks{


    protected String TAG = this.getClass().getSimpleName();

    private Handler handler = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }


    @Override
    public void show(String message) {
        ToastUtils.show(message);
    }

    @Override
    public void show(int resourceId) {
        show(getResources().getString(resourceId));
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    public final <E extends View> E getView(int id) {
        try {
            return (E) findViewById(id);
        } catch (ClassCastException ex) {
            LogUtils.e("getView error",
                    "Could not cast View to concrete class.");
            throw ex;
        }
    }

    @Override
    public void jumpActivity(Class<? extends Activity> clazz, boolean needLogin) {
        if(needLogin) {
            if (isLogin()) {
                Intent intent = new Intent(this, clazz);
                startActivity(intent);
            }
        }else{
            Intent intent = new Intent(this, clazz);
            startActivity(intent);
        }
    }


    @Override
    public void jumpActivity(Class<? extends Activity> clazz, int flag, boolean needLogin) {
        if(needLogin) {
            if (isLogin()) {
                Intent intent = new Intent(this, clazz);
                intent.setFlags(flag);
                startActivity(intent);
            }
        }else{
            Intent intent = new Intent(this, clazz);
            intent.setFlags(flag);
            startActivity(intent);
        }
    }

    @Override
    public void jumpActivityForResult(Class<? extends Activity> clazz,
                                      int requestCode, boolean needLogin) {
        if(needLogin) {
            if (isLogin()) {
                Intent intent = new Intent(this, clazz);
                startActivityForResult(intent, requestCode);
            }
        }else{
            Intent intent = new Intent(this, clazz);
            startActivityForResult(intent, requestCode);
        }
    }

    @Override
    public void jumpActivityForResult(Class<? extends Activity> clazz, Bundle data,
                                      int requestCode, boolean needLogin) {
        if(needLogin) {
            if (isLogin()) {
                Intent intent = new Intent(this, clazz);
                intent.putExtras(data);
                startActivityForResult(intent, requestCode);
            }
        }else {
            Intent intent = new Intent(this, clazz);
            intent.putExtras(data);
            startActivityForResult(intent, requestCode);
        }
    }


    @Override
    public void jumpActivity(Class<? extends Activity> clazz, Bundle data, boolean needLogin) {
        if(needLogin) {
            if (isLogin()) {
                Intent intent = new Intent(this, clazz);
                intent.putExtras(data);
                startActivity(intent);
            }
        }else {
            Intent intent = new Intent(this, clazz);
            intent.putExtras(data);
            startActivity(intent);
        }
    }

    @Override
    public void jumpActivity(Class<? extends Activity> clazz, Bundle data,
                             int flag, boolean needLogin) {
        if(needLogin) {
            if (isLogin()) {
                Intent intent = new Intent(this, clazz);
                intent.putExtras(data);
                intent.setFlags(flag);
                startActivity(intent);
            }
        }else {
            Intent intent = new Intent(this, clazz);
            intent.putExtras(data);
            intent.setFlags(flag);
            startActivity(intent);
        }
    }

    @Override
    public void jumpActivity(Intent intent, boolean needLogin) {
        if(needLogin) {
            if (isLogin()) {
                startActivity(intent);
            }
        }else {
            startActivity(intent);
        }
    }

    @Override
    public boolean isLogined() {
        return false;
    }

    /**
     * 检测是否登录，如果未登录会自动开启登录页面
     */
    public boolean isLogin(){
        if(!isLogined()){
            //TODO 没有登录的话需要进入登录页面
            return false;
        }
        return true;
    }

    @Override
    public void doJump(Intent intent) {
        startActivity(intent);
    }

    @Override
    public void doCloseCurrentPage() {
        finish();
    }

    @Override
    public void doSendBroadcast(Intent intent) {
        sendBroadcast(intent);
    }

    @Override
    public void postRunnable(Runnable runnable) {
        if(runnable != null) {
            if(handler == null)
                handler = new Handler();
            handler.post(runnable);
        }
    }



    private IPermissionCheck permissionRequestCallback;
    private int permissionRequestCode;

    public void requestPermissions(@NonNull String[] permissions, @NonNull int code, @NonNull String reason, IPermissionCheck callback){
        permissionRequestCallback = callback;
        permissionRequestCode = code;
        //判断有没有权限
        if (EasyPermissions.hasPermissions(this, permissions)) {
            LogUtils.e("aaa","************hasPermissions");
            // 如果有权限了, 就做你该做的事情
            if(permissionRequestCallback != null)
                permissionRequestCallback.hasGotPermissions(code);
        } else {
            // 如果没有权限, 就去申请权限
            // this: 上下文
            // Dialog显示的正文
            // code 请求码, 用于回调的时候判断是哪次申请
            // perms 就是你要申请的权限

            LogUtils.e("aaa","************has NO Permissions");
            EasyPermissions.requestPermissions(this, reason, code, permissions);
        }
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        // 将返回结果转给EasyPermissions
        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }


    @Override
    public void onPermissionsGranted(int requestCode, @NonNull List<String> perms) {
        permissionRequestCallback.hasGotPermissions(permissionRequestCode);
    }

    @Override
    public void onPermissionsDenied(int requestCode, @NonNull List<String> perms) {
        new AppSettingsDialog.Builder(this)
                .setTitle("权限已经被您拒绝")
                .setRationale("如果不打开权限则app可能有部分功能无法正常使用,点击确定去打开权限")
                .setRequestCode(requestCode)//用于onActivityResult回调做其它对应相关的操作
                .build()
                .show();

    }

    /**
     * 设置状态栏的颜色
     * @param activity
     * @param colorId
     */
    public static void setStatusBarColor(Activity activity, int colorId) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = activity.getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(activity.getResources().getColor(colorId));
        }
    }

    protected static void setAndroidNativeLightStatusBar(Activity activity, boolean dark) {
        View decor = activity.getWindow().getDecorView();
        if (dark) {
            decor.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
        } else {
            decor.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
        }
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
            View v = getCurrentFocus();
            if (isShouldHideInput(v, ev)) {

                InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                if (imm != null) {
                    imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                }
            }
            return super.dispatchTouchEvent(ev);
        }
        // 必不可少，否则所有的组件都不会有TouchEvent了
        if (getWindow().superDispatchTouchEvent(ev)) {
            return true;
        }
        return onTouchEvent(ev);
    }

    public  boolean isShouldHideInput(View v, MotionEvent event) {
        if (v != null && (v instanceof EditText)) {
            int[] leftTop = { 0, 0 };
            //获取输入框当前的location位置
            v.getLocationInWindow(leftTop);
            int left = leftTop[0];
            int top = leftTop[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
            if (event.getX() > left && event.getX() < right
                    && event.getY() > top && event.getY() < bottom) {
                // 点击的是输入框区域，保留点击EditText的事件
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onPause() {
        super.onPause();

    }

    @Override
    protected void onResume() {
        super.onResume();
    }
}
