/*
 * Decompiled with CFR 0.152.
 */
package com.invs;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.SystemClock;
import com.invs.invsIdCard;
import com.invs.invsUtil;
import java.util.Arrays;
import java.util.HashMap;

public class UsbBase {
    public invsIdCard mCard = null;
    protected final long TIMEOUT = 1500L;
    protected byte[] mCardId = new byte[8];
    protected byte[] mData = new byte[2500];
    public static final String ACTION_USB_PERMISSION = "com.guoteng.USB_PERMISSION";
    private UsbDeviceConnection myDeviceConnection = null;
    private byte[] mTmp = new byte[2000];
    protected String mSamId = "";
    protected byte[] CardSn = new byte[8];
    protected byte[] DevId = new byte[12];
    protected boolean mSdtDev = false;
    UsbEndpoint epOut;
    UsbEndpoint epIn;
    int m_iDataLen = 0;

    protected boolean BytesEqual(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null || b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void BytesFill(byte[] b, int c) {
        if (b == null) {
            return;
        }
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)c;
            ++i;
        }
    }

    public void CloseComm() {
        this.BytesFill(this.mCardId, 0);
        if (this.myDeviceConnection != null) {
            try {
                this.myDeviceConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myDeviceConnection = null;
    }

    private void getEndpoint(UsbDeviceConnection connection, UsbInterface intf) {
        if (intf.getEndpoint(1) != null) {
            this.epOut = intf.getEndpoint(1);
        }
        if (intf.getEndpoint(0) != null) {
            this.epIn = intf.getEndpoint(0);
        }
    }

    public static UsbDevice GetUsb(Context context) {
        UsbManager myUsbManager = (UsbManager)context.getSystemService("usb");
        UsbDevice myUsbDevice = null;
        HashMap deviceList = myUsbManager.getDeviceList();
        if (deviceList.size() == 0) {
            return null;
        }
        for (UsbDevice device : deviceList.values()) {
            if (device.getVendorId() == 4292 && device.getProductId() == 33896) {
                myUsbDevice = device;
                continue;
            }
            if (device.getVendorId() == 4292 && device.getProductId() == 46110) {
                myUsbDevice = device;
                continue;
            }
            if (device.getVendorId() != 1024 || device.getProductId() != 50010) continue;
            myUsbDevice = device;
        }
        if (myUsbDevice == null) {
            return null;
        }
        return myUsbDevice;
    }

    /*
     * Unable to fully structure code
     */
    public static int checkUsbDev(Context context) {
        myUsbManager = (UsbManager)context.getSystemService("usb");
        myUsbDevice = UsbBase.GetUsb(context);
        if (myUsbDevice != null) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            myUsbDevice = UsbBase.GetUsb(context);
            if (myUsbDevice == null) {
                return -1;
            }
            myUsbManager.requestPermission(myUsbDevice, PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent("com.guoteng.USB_PERMISSION"), (int)0));
lbl9:
            // 2 sources

            ** while (!myUsbManager.hasPermission((UsbDevice)myUsbDevice))
        }
lbl10:
        // 1 sources

        return 0;
    }

    public static int CheckDev(Context context) {
        UsbDevice myUsbDevice;
        UsbManager myUsbManager;
        block10: {
            HashMap deviceList;
            block9: {
                myUsbManager = (UsbManager)context.getSystemService("usb");
                myUsbDevice = null;
                deviceList = myUsbManager.getDeviceList();
                if (deviceList.size() != 0) break block9;
                return -1;
            }
            try {
                for (UsbDevice device : deviceList.values()) {
                    if (device.getVendorId() == 4292 && device.getProductId() == 33896) {
                        myUsbDevice = device;
                        continue;
                    }
                    if (device.getVendorId() == 4292 && device.getProductId() == 46110) {
                        myUsbDevice = device;
                        continue;
                    }
                    if (device.getVendorId() != 1024 || device.getProductId() != 50010) continue;
                    myUsbDevice = device;
                }
                if (myUsbDevice != null) break block10;
                return -1;
            }
            catch (Exception e) {
                return -1;
            }
        }
        if (!myUsbManager.hasPermission(myUsbDevice)) {
            myUsbManager.requestPermission(myUsbDevice, PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0));
        }
        if (!myUsbManager.hasPermission(myUsbDevice)) {
            return 0;
        }
        return 1;
    }

    public int InitComm(Context context) {
        UsbInterface myInterface;
        block19: {
            block18: {
                UsbDevice myUsbDevice;
                block17: {
                    UsbManager myUsbManager;
                    block16: {
                        block15: {
                            HashMap deviceList;
                            block14: {
                                this.CloseComm();
                                myUsbManager = (UsbManager)context.getSystemService("usb");
                                myUsbDevice = null;
                                deviceList = myUsbManager.getDeviceList();
                                if (deviceList.size() != 0) break block14;
                                return -1;
                            }
                            try {
                                for (UsbDevice device : deviceList.values()) {
                                    if (device.getVendorId() == 4292 && device.getProductId() == 33896) {
                                        myUsbDevice = device;
                                        this.mSdtDev = false;
                                        continue;
                                    }
                                    if (device.getVendorId() == 4292 && device.getProductId() == 46110) {
                                        myUsbDevice = device;
                                        this.mSdtDev = false;
                                        continue;
                                    }
                                    if (device.getVendorId() != 1024 || device.getProductId() != 50010) continue;
                                    myUsbDevice = device;
                                    this.mSdtDev = true;
                                }
                                if (myUsbDevice != null) break block15;
                                return -1;
                            }
                            catch (Exception e) {
                                SystemClock.sleep((long)10L);
                                return -1;
                            }
                        }
                        if (!myUsbManager.hasPermission(myUsbDevice)) {
                            myUsbManager.requestPermission(myUsbDevice, PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0));
                        }
                        if (myUsbManager.hasPermission(myUsbDevice)) break block16;
                        return -1;
                    }
                    this.myDeviceConnection = myUsbManager.openDevice(myUsbDevice);
                    if (this.myDeviceConnection != null) break block17;
                    return -1;
                }
                myInterface = myUsbDevice.getInterface(0);
                if (myInterface != null) break block18;
                return -1;
            }
            if (this.myDeviceConnection.claimInterface(myInterface, true)) break block19;
            return -1;
        }
        if (this.mSdtDev) {
            this.getEndpoint(this.myDeviceConnection, myInterface);
        }
        this.mSamId = this.ReadSamidCmd();
        if (this.mSamId == "") {
            return -3;
        }
        return 1;
    }

    protected boolean SendData(byte[] data, int len) {
        int i = 0;
        try {
            i = this.mSdtDev ? this.myDeviceConnection.bulkTransfer(this.epOut, data, len, 100) : this.myDeviceConnection.controlTransfer(33, 9, 512, 0, data, len, 100);
        }
        catch (Exception e) {
            SystemClock.sleep((long)10L);
            return false;
        }
        return i == len;
    }

    protected int RecvData(byte[] data, int pos, int len) {
        int i = 0;
        try {
            i = this.mSdtDev ? this.myDeviceConnection.bulkTransfer(this.epIn, this.mTmp, 64, 1000) : this.myDeviceConnection.controlTransfer(161, 1, 256, 0, this.mTmp, 64, 100);
            System.arraycopy(this.mTmp, 0, data, pos, i);
        }
        catch (Exception e) {
            return -2;
        }
        return i;
    }

    protected byte ChkSum(byte[] Data, int iPos, int iLen) {
        if (iLen == 0) {
            return 0;
        }
        byte cSum = 0;
        int i = 0;
        while (i < iLen) {
            cSum = (byte)(cSum ^ Data[i + iPos]);
            ++i;
        }
        return cSum;
    }

    protected boolean SendCmdData(byte[] pData, int iLen) {
        byte[] Data = new byte[50];
        Data[0] = -86;
        Data[1] = -86;
        Data[2] = -86;
        Data[3] = -106;
        Data[4] = 105;
        if (iLen + 7 + 1 > 50) {
            return false;
        }
        Data[5] = (byte)(iLen + 1 >> 8 & 0xFF);
        Data[6] = (byte)(iLen + 1 & 0xFF);
        System.arraycopy(pData, 0, Data, 7, iLen);
        Data[7 + iLen] = this.ChkSum(Data, 5, iLen + 2);
        return this.SendData(Data, 7 + iLen + 1);
    }

    protected long GetTickCount() {
        return SystemClock.uptimeMillis();
    }

    protected int RecvCmdResult(long timeout) {
        Arrays.fill(this.mData, (byte)0);
        int iDataLen = 0;
        int iPos = 0;
        boolean bHead = false;
        this.m_iDataLen = 0;
        long tick = this.GetTickCount();
        while (this.GetTickCount() - tick < timeout) {
            int iLen = this.RecvData(this.mData, iPos, this.mData.length - iPos);
            if (iLen == 0 || iLen < 0 || (iPos += iLen) < 5) continue;
            if (!bHead && !(bHead = invsUtil.checkHead(this.mData))) {
                iPos = 0;
                SystemClock.sleep((long)50L);
                continue;
            }
            if (iDataLen == 0 && iPos > 7) {
                int iLow = this.mData[6] & 0xFF;
                int iHight = (this.mData[5] & 0xFF) << 8;
                this.m_iDataLen = iDataLen = iHight + iLow;
            }
            if (iPos - 7 < iDataLen) continue;
            if (this.ChkSum(this.mData, 5, iDataLen + 2 - 1) != this.mData[iDataLen + 6]) {
                return 0;
            }
            return 0xFF & this.mData[9];
        }
        return 0;
    }

    protected int SendCmd(byte[] szData, int iLen, int iDelay, long iTimeOut) {
        if (!this.SendCmdData(szData, iLen)) {
            return 0;
        }
        if (iDelay > 0) {
            SystemClock.sleep((long)iDelay);
        }
        int iResult = this.RecvCmdResult(iTimeOut);
        return iResult;
    }

    protected String SamID_Caculate(byte[] SamID, int iPos) {
        String szResult = "";
        long iLow = SamID[0 + iPos] & 0xFF;
        long iHight = (long)(SamID[1 + iPos] & 0xFF) << 8;
        long iTmp = iHight + iLow;
        szResult = Long.toString(iTmp);
        szResult = String.valueOf(szResult) + "-";
        iLow = SamID[2 + iPos] & 0xFF;
        iHight = (long)(SamID[3 + iPos] & 0xFF) << 8;
        iTmp = iHight + iLow;
        szResult = String.valueOf(szResult) + Long.toString(iTmp) + "-";
        iLow = SamID[4 + iPos] & 0xFF;
        iHight = (long)(SamID[5 + iPos] & 0xFF) << 8;
        iTmp = iHight + iLow;
        iLow = (long)(SamID[6 + iPos] & 0xFF) << 16;
        iHight = (long)(SamID[7 + iPos] & 0xFF) << 24;
        iTmp = iTmp + iHight + iLow;
        szResult = String.valueOf(szResult) + Long.toString(iTmp) + "-";
        iLow = SamID[8 + iPos] & 0xFF;
        iHight = (long)(SamID[9 + iPos] & 0xFF) << 8;
        iTmp = iHight + iLow;
        iLow = (long)(SamID[10 + iPos] & 0xFF) << 16;
        iHight = (long)(SamID[11 + iPos] & 0xFF) << 24;
        iTmp = iTmp + iHight + iLow;
        szResult = String.valueOf(szResult) + Long.toString(iTmp) + "-";
        iLow = SamID[12 + iPos] & 0xFF;
        iHight = (long)(SamID[13 + iPos] & 0xFF) << 8;
        iTmp = iHight + iLow;
        iLow = (long)(SamID[14 + iPos] & 0xFF) << 16;
        iHight = (long)(SamID[15 + iPos] & 0xFF) << 24;
        iTmp = iTmp + iHight + iLow;
        szResult = String.valueOf(szResult) + Long.toString(iTmp);
        return szResult;
    }

    public String ReadSamidCmd() {
        byte[] szData = new byte[]{18, -1};
        int iCmd = this.SendCmd(szData, 2, 150, 1500L);
        if (iCmd != 144) {
            return "";
        }
        this.mSamId = this.SamID_Caculate(this.mData, 10);
        return this.mSamId;
    }

    public int ReadCardId(byte[] cardId) {
        int i = 0;
        while (i < cardId.length) {
            cardId[i] = 0;
            ++i;
        }
        byte[] szData = new byte[]{82, 8};
        int iCmd = this.SendCmd(szData, 2, 100, 1500L);
        if (iCmd != 144) {
            return iCmd;
        }
        System.arraycopy(this.mData, 10, cardId, 0, 8);
        return 0;
    }

    public int ReadACardId(byte[] cardId) {
        int i = 0;
        while (i < cardId.length) {
            cardId[i] = 0;
            ++i;
        }
        byte[] szData = new byte[]{82, 9};
        int iCmd = this.SendCmd(szData, 2, 100, 1500L);
        if (iCmd != 144) {
            return iCmd;
        }
        System.arraycopy(this.mData, 10, cardId, 0, 9);
        return 0;
    }
}

