/*
 * Decompiled with CFR 0.152.
 */
package com.brilliants.idcardlib;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.util.Log;
import com.brilliants.idcardlib.ReadIDCardCallBack;
import com.invs.UsbBase;
import com.invs.UsbSam;

public class IDCardService
extends Service {
    private String TAG = "IDCardService";
    public static final String USB_ID_CARD_CONNETION = "com.viking.invscard.connection";
    public static final String USB_ID_CARD_UNCONNETION = "com.viking.invscard.unconnection";
    private UsbSam mTermb = new UsbSam();
    private volatile boolean readIDCard = true;
    private ReadIDCardCallBack callback = null;
    private boolean isReadCard = true;
    Thread cardThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (IDCardService.this.isReadCard) {
                int readcode;
                int checkdevicecode = IDCardService.this.checkIDCardDevice();
                if (checkdevicecode != 1) continue;
                int initcode = IDCardService.this.mTermb.InitComm(IDCardService.this.getApplicationContext());
                if (initcode != 1) {
                    if (IDCardService.this.mTermb == null) continue;
                    IDCardService.this.mTermb.CloseComm();
                    continue;
                }
                int findcode = IDCardService.this.findIDCard1();
                if (findcode != 128 && findcode != 159) {
                    if (IDCardService.this.mTermb == null) continue;
                    IDCardService.this.mTermb.CloseComm();
                    continue;
                }
                if (findcode == 128) {
                    if (!IDCardService.this.readIDCard) continue;
                    try {
                        int readcode2 = IDCardService.this.mTermb.ReadCardCmd(false);
                        if (readcode2 != 144 || IDCardService.this.callback == null || IDCardService.this.mTermb == null) continue;
                        IDCardService.this.callback.readIDCardData(((IDCardService)IDCardService.this).mTermb.mCard, false);
                    }
                    catch (Exception e) {
                        Log.e((String)IDCardService.this.TAG, (String)e.toString());
                    }
                    continue;
                }
                if (findcode != 159) continue;
                int selcode = IDCardService.this.mTermb.SelCardCmd();
                if (selcode != 129 && selcode != 144) {
                    if (IDCardService.this.mTermb == null) continue;
                    IDCardService.this.mTermb.CloseComm();
                    continue;
                }
                if (selcode != 129 && selcode != 144 || !IDCardService.this.readIDCard || (readcode = IDCardService.this.mTermb.ReadCardCmd(false)) != 144 || IDCardService.this.callback == null) continue;
                IDCardService.this.callback.readIDCardData(((IDCardService)IDCardService.this).mTermb.mCard, true);
            }
        }
    });
    private int oldCode = 0;

    @Nullable
    public IBinder onBind(Intent intent) {
        return new Binder();
    }

    public void setCallback(ReadIDCardCallBack callback) {
        this.callback = callback;
    }

    public void onCreate() {
        super.onCreate();
        if (this.cardThread != null) {
            this.cardThread.start();
        }
    }

    public synchronized void ReadIDCard() {
        this.readIDCard = true;
    }

    private synchronized int findIDCard1() {
        if (this.mTermb != null) {
            return this.mTermb.FindCardCmd();
        }
        return -1;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    private int checkIDCardDevice() {
        int code = UsbBase.CheckDev((Context)this);
        if (code == this.oldCode) {
            return code;
        }
        if (code == 1) {
            Intent intent = new Intent();
            intent.setAction(USB_ID_CARD_CONNETION);
            this.sendBroadcast(intent);
            this.oldCode = 1;
            return 1;
        }
        int code1 = UsbBase.CheckDev((Context)this);
        if (code1 != 1) {
            int code2 = UsbBase.CheckDev((Context)this);
            if (code2 != 1) {
                Intent intent = new Intent();
                intent.setAction(USB_ID_CARD_UNCONNETION);
                this.sendBroadcast(intent);
                this.oldCode = -1;
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        Log.e((String)"idcardservice", (String)"onDestroy: ");
        if (this.cardThread != null) {
            this.isReadCard = false;
            this.cardThread.interrupt();
            this.cardThread = null;
        }
    }

    public class Binder
    extends android.os.Binder {
        public IDCardService getService() {
            return IDCardService.this;
        }
    }
}

