/*
 * Decompiled with CFR 0.152.
 */
package com.brilliants.idcardlib;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import com.brilliants.idcardlib.IDCardCallBack;
import com.brilliants.idcardlib.IDCardService;
import com.brilliants.idcardlib.ReadIDCardCallBack;
import com.invs.invsIdCard;

public class IDCard {
    String TAG = "IDCard";
    private Context mContext = null;
    private IDCardCallBack mIDCardCallBack = null;
    private final Intent mIntent;
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.e((String)IDCard.this.TAG, (String)"onServiceConnected: ");
            IDCardService.Binder binder = (IDCardService.Binder)service;
            IDCardService idCardService = binder.getService();
            idCardService.setCallback(new ReadIDCardCallBack(){

                @Override
                public void readIDCardData(invsIdCard invsIdCard2, boolean b) {
                    if (IDCard.this.mIDCardCallBack != null) {
                        IDCard.this.mIDCardCallBack.readIDCardData(invsIdCard2, b);
                    }
                }

                @Override
                public void readIDCardDataFail() {
                    if (IDCard.this.mIDCardCallBack != null) {
                        IDCard.this.mIDCardCallBack.readIDCardDataFail();
                    }
                }
            });
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    };
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "com.viking.invscard.connection": {
                    if (IDCard.this.mIDCardCallBack == null) break;
                    IDCard.this.mIDCardCallBack.idCardDeviceComment();
                    break;
                }
                case "com.viking.invscard.unconnection": {
                    if (IDCard.this.mIDCardCallBack == null) break;
                    IDCard.this.mIDCardCallBack.idCardDeviceUnComment();
                }
            }
        }
    };

    public IDCard(Context context, IDCardCallBack idCardCallBack) {
        Log.e((String)this.TAG, (String)("IDCard: " + (idCardCallBack != null)));
        this.mContext = context;
        if (this.mIDCardCallBack == null) {
            this.mIDCardCallBack = idCardCallBack;
        }
        this.mIntent = new Intent(this.mContext, IDCardService.class);
        this.mContext.bindService(this.mIntent, this.mServiceConnection, 1);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.viking.invscard.connection");
        intentFilter.addAction("com.viking.invscard.unconnection");
        this.mContext.registerReceiver(this.mBroadcastReceiver, intentFilter);
    }

    public void unInit() {
        if (this.mServiceConnection != null) {
            this.mContext.unbindService(this.mServiceConnection);
            this.mServiceConnection = null;
        }
    }
}

