/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.table;

import com.lidroid.xutils.db.annotation.NoAutoIncrement;
import com.lidroid.xutils.db.table.Column;
import com.lidroid.xutils.util.LogUtils;
import java.lang.reflect.Field;
import java.util.HashSet;

public class Id
extends Column {
    private String columnFieldClassName = this.columnField.getType().getName();
    private boolean isAutoIncrementChecked = false;
    private boolean isAutoIncrement = false;
    private static final HashSet<String> INTEGER_TYPES = new HashSet(2);
    private static final HashSet<String> AUTO_INCREMENT_TYPES = new HashSet(4);

    static {
        INTEGER_TYPES.add(Integer.TYPE.getName());
        INTEGER_TYPES.add(Integer.class.getName());
        AUTO_INCREMENT_TYPES.addAll(INTEGER_TYPES);
        AUTO_INCREMENT_TYPES.add(Long.TYPE.getName());
        AUTO_INCREMENT_TYPES.add(Long.class.getName());
    }

    Id(Class<?> entityType, Field field) {
        super(entityType, field);
    }

    public boolean isAutoIncrement() {
        if (!this.isAutoIncrementChecked) {
            this.isAutoIncrementChecked = true;
            this.isAutoIncrement = this.columnField.getAnnotation(NoAutoIncrement.class) == null && AUTO_INCREMENT_TYPES.contains(this.columnFieldClassName);
        }
        return this.isAutoIncrement;
    }

    public void setAutoIncrementId(Object entity, long value) {
        Number idValue = value;
        if (INTEGER_TYPES.contains(this.columnFieldClassName)) {
            idValue = (int)value;
        }
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(entity, idValue);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        } else {
            try {
                this.columnField.setAccessible(true);
                this.columnField.set(entity, idValue);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        }
    }

    @Override
    public Object getColumnValue(Object entity) {
        Object idValue = super.getColumnValue(entity);
        if (idValue != null) {
            if (this.isAutoIncrement() && (idValue.equals(0) || idValue.equals(0L))) {
                return null;
            }
            return idValue;
        }
        return null;
    }
}

