/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.table;

import android.database.Cursor;
import com.lidroid.xutils.db.converter.ColumnConverter;
import com.lidroid.xutils.db.converter.ColumnConverterFactory;
import com.lidroid.xutils.db.sqlite.ColumnDbType;
import com.lidroid.xutils.db.sqlite.ForeignLazyLoader;
import com.lidroid.xutils.db.table.Column;
import com.lidroid.xutils.db.table.ColumnUtils;
import com.lidroid.xutils.db.table.Id;
import com.lidroid.xutils.db.table.Table;
import com.lidroid.xutils.db.table.TableUtils;
import com.lidroid.xutils.exception.DbException;
import com.lidroid.xutils.util.LogUtils;
import java.lang.reflect.Field;
import java.util.List;

public class Foreign
extends Column {
    private final String foreignColumnName;
    private final ColumnConverter foreignColumnConverter;

    Foreign(Class<?> entityType, Field field) {
        super(entityType, field);
        this.foreignColumnName = ColumnUtils.getForeignColumnNameByField(field);
        Class<?> foreignColumnType = TableUtils.getColumnOrId(this.getForeignEntityType(), (String)this.foreignColumnName).columnField.getType();
        this.foreignColumnConverter = ColumnConverterFactory.getColumnConverter(foreignColumnType);
    }

    public String getForeignColumnName() {
        return this.foreignColumnName;
    }

    public Class<?> getForeignEntityType() {
        return ColumnUtils.getForeignEntityType(this);
    }

    @Override
    public void setValue2Entity(Object entity, Cursor cursor, int index) {
        Object fieldValue = this.foreignColumnConverter.getFieldValue(cursor, index);
        if (fieldValue == null) {
            return;
        }
        Object value = null;
        Class<?> columnType = this.columnField.getType();
        if (columnType.equals(ForeignLazyLoader.class)) {
            value = new ForeignLazyLoader(this, fieldValue);
        } else if (columnType.equals(List.class)) {
            try {
                value = new ForeignLazyLoader(this, fieldValue).getAllFromDb();
            }
            catch (DbException e) {
                LogUtils.e(e.getMessage(), e);
            }
        } else {
            try {
                value = new ForeignLazyLoader(this, fieldValue).getFirstFromDb();
            }
            catch (DbException e) {
                LogUtils.e(e.getMessage(), e);
            }
        }
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(entity, value);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        } else {
            try {
                this.columnField.setAccessible(true);
                this.columnField.set(entity, value);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        }
    }

    @Override
    public Object getColumnValue(Object entity) {
        Object fieldValue = this.getFieldValue(entity);
        Object columnValue = null;
        if (fieldValue != null) {
            Class<?> columnType = this.columnField.getType();
            if (columnType.equals(ForeignLazyLoader.class)) {
                columnValue = ((ForeignLazyLoader)fieldValue).getColumnValue();
            } else if (columnType.equals(List.class)) {
                try {
                    List foreignEntities = (List)fieldValue;
                    if (foreignEntities.size() > 0) {
                        Class<?> foreignEntityType = ColumnUtils.getForeignEntityType(this);
                        Column column = TableUtils.getColumnOrId(foreignEntityType, this.foreignColumnName);
                        columnValue = column.getColumnValue(foreignEntities.get(0));
                        Table table = this.getTable();
                        if (table != null && column instanceof Id) {
                            for (Object foreignObj : foreignEntities) {
                                Object idValue = column.getColumnValue(foreignObj);
                                if (idValue != null) continue;
                                table.db.saveOrUpdate(foreignObj);
                            }
                        }
                        columnValue = column.getColumnValue(foreignEntities.get(0));
                    }
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            } else {
                try {
                    Column column = TableUtils.getColumnOrId(columnType, this.foreignColumnName);
                    columnValue = column.getColumnValue(fieldValue);
                    Table table = this.getTable();
                    if (table != null && columnValue == null && column instanceof Id) {
                        table.db.saveOrUpdate(fieldValue);
                    }
                    columnValue = column.getColumnValue(fieldValue);
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
        return columnValue;
    }

    @Override
    public ColumnDbType getColumnDbType() {
        return this.foreignColumnConverter.getColumnDbType();
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }
}

