/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap.callback;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Animation;
import com.lidroid.xutils.bitmap.BitmapDisplayConfig;
import com.lidroid.xutils.bitmap.callback.BitmapLoadCallBack;
import com.lidroid.xutils.bitmap.callback.BitmapLoadFrom;
import java.lang.reflect.Method;

public class DefaultBitmapLoadCallBack<T extends View>
extends BitmapLoadCallBack<T> {
    @Override
    public void onLoadCompleted(T container, String uri, Bitmap bitmap, BitmapDisplayConfig config, BitmapLoadFrom from) {
        this.setBitmap(container, bitmap);
        Animation animation = config.getAnimation();
        if (animation != null) {
            this.animationDisplay(container, animation);
        }
    }

    @Override
    public void onLoadFailed(T container, String uri, Drawable drawable) {
        this.setDrawable(container, drawable);
    }

    private void animationDisplay(T container, Animation animation) {
        try {
            Method cloneMethod = Animation.class.getDeclaredMethod("clone", new Class[0]);
            cloneMethod.setAccessible(true);
            container.startAnimation((Animation)cloneMethod.invoke((Object)animation, new Object[0]));
        }
        catch (Throwable e) {
            container.startAnimation(animation);
        }
    }
}

