package cn.dankal.test.service;

import cn.dankal.test.KafkaTestApplication;
import cn.dankal.test.common.Const;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * @author ZGH.MercyModest
 * @version V1.0.0
 * @create 2021-01-21
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = {KafkaTestApplication.class})
public class KafkaMessageServiceTest {

    /**
     * KafkaMessageService
     */
    @Autowired
    private KafkaMessageService kafkaMessageService;

    /**
     * 测试 发送 string 类型的 Kafka 消息
     */
    @Test
    public void testSendStringMessageToKafka() {
        final String topic = Const.Kafka.Topic.TOPIC_SIMPLE_STRING_MESSAGE;
        final String key = "dankal-test";
        final String message = "Hello,Kafka~(蛋壳创意科技)";
        boolean sendSuccess = kafkaMessageService.sendStringMessage(topic, key, message);
        if (sendSuccess) {
            System.out.println("消息发送成功");
        }
    }
}
