package cn.dankal.test.service.impl;

import cn.dankal.test.service.KafkaMessageService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Repository;

/**
 * @author ZGH.MercyModest
 * @version V1.0.0
 * @create 2021-01-21
 */
@Slf4j
@Repository
public class KafkaMessageServiceImpl implements KafkaMessageService {

    /**
     * kafkaTemplate
     */
    private final KafkaTemplate<String, String> kafkaTemplate;

    public KafkaMessageServiceImpl(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    @Override
    public boolean sendStringMessage(String topic, String key, String message) {
        kafkaTemplate.send(topic, key, message)
                .addCallback(System.out::println, Throwable::printStackTrace);
        return true;
    }
}
