package cn.dankal.test.listener;

import cn.dankal.test.common.Const;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

/**
 * @author ZGH.MercyModest
 * @version V1.0.0
 * @create 2021-01-21
 */
@Slf4j
@Component
public class KafkaMessageListener {


    @KafkaListener(
            topics = {Const.Kafka.Topic.TOPIC_SIMPLE_STRING_MESSAGE},
            groupId = Const.Kafka.ConsumerGroupId.GROUP_ID_SIMPLE_STRING_CONSUMER
    )
    public void stringMessageListener(ConsumerRecord<?, ?> data,
                                      Acknowledgment acknowledgment,
                                      Consumer<?, ?> consumer) {
        if (log.isInfoEnabled()) {
            log.info("{} 消费消息 ==> 主题: {} 分区: {} 偏移量: {} key: {} value: {}",
                    Thread.currentThread().getName(),
                    data.topic(),
                    data.partition(),
                    data.offset(),
                    data.key(),
                    data.value());
        }
        acknowledgment.acknowledge();
    }
}
