package cn.dankal.test.config;

import cn.dankal.test.common.Const;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author ZGH.MercyModest
 * @version V1.0.0
 * @create 2021-01-22
 */
@Configuration
public class KafkaTopicConfig {

    /**
     * KafkaProperties
     */
    private final KafkaProperties kafkaProperties;

    public KafkaTopicConfig(KafkaProperties kafkaProperties) {
        this.kafkaProperties = kafkaProperties;
    }

    @Bean
    public KafkaAdmin admin() {
        Map<String, Object> configs = new HashMap<>(1 << 5);
        configs.put(AdminClientConfig.BOOTSTRAP_SERVERS_CONFIG,
                StringUtils.arrayToCommaDelimitedString(kafkaProperties.getBootstrapServers().toArray()));
        return new KafkaAdmin(configs);
    }

    @Bean
    public NewTopic simpleStringTopic() {
        return new NewTopic(
                Const.Kafka.Topic.TOPIC_SIMPLE_STRING_MESSAGE,
                kafkaProperties.getListener().getConcurrency(),
                (short) 3);
    }
}
