package cn.dankal.test.commandline;

import cn.dankal.test.common.Const;
import cn.dankal.test.service.KafkaMessageService;
import cn.hutool.core.util.RandomUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * @author ZGH.MercyModest
 * @version V1.0.0
 * @create 2021-01-22
 */
@Slf4j
@Component
public class KafkaMessageSendCommandLineRunner implements CommandLineRunner {

    /**
     * KafkaMessageService
     */
    private final KafkaMessageService kafkaMessageService;

    public KafkaMessageSendCommandLineRunner(KafkaMessageService kafkaMessageService) {
        this.kafkaMessageService = kafkaMessageService;
    }

    @Override
    public void run(String... args) throws Exception {
        while (true) {
            final String topic = Const.Kafka.Topic.TOPIC_SIMPLE_STRING_MESSAGE;
            final String key = "dankal-test-" + RandomUtil.randomInt(100, 100000000);
            final String message = "蛋壳创意科技-" + RandomUtil.randomString(Const.RANDOM_BASE_STRING, 1000);
            TimeUnit.MILLISECONDS.sleep(230);
            boolean sendSuccess = kafkaMessageService.sendStringMessage(topic, key, message);
            if (sendSuccess) {
                System.out.println("消息发送成功~");
                if (log.isDebugEnabled()) {
                    log.debug("成功发送消息: key: {}  value: {}", key, message);
                }
            }
        }
    }
}
