-- 设备设备码表
CREATE TABLE `t_device_code`
(
    `id`                       BIGINT       NOT NULL PRIMARY KEY COMMENT '主键',
    `user_device_code_id`      BIGINT       NOT NULL COMMENT '用户设备码ID(t_user_device_codes.user_device_code_id)',
    `device_id`                BIGINT       NULL COMMENT '登录设备ID(t_device.device_id)',
    `virtual_device_id`        BIGINT       NOT NULL COMMENT '虚拟设备ID(t_user_device_codes.device_id)',
    `device_code`              VARCHAR(20)  NOT NULL COMMENT '设备码',
    `device_name`              VARCHAR(400) NULL COMMENT '设备名称',
    `login_status`             TINYINT      NOT NULL DEFAULT 0 COMMENT '登录状态: 0: 未登录 1: 已登录',
    `device_login_logout_time` DATETIME(3)  NULL COMMENT '设备(登录/登出)时间',
    `device_code_expire_time`  DATETIME     NULL COMMENT '设备码过期时间',
    `private_cert`             VARCHAR(255) NULL COMMENT '设备私钥(t_device.private_cert)',
    `create_time`              DATETIME(3)  NOT NULL COMMENT '创建时间',
    `update_time`              DATETIME(3)  NOT NULL COMMENT '更新时间',
    UNIQUE INDEX uniq_device_code (`device_code`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT = '设备设备码表';

-- idx virtual_device_id,device_id
CREATE INDEX idx_virtual_device_id_device_id ON `t_device_code` (`virtual_device_id`, `device_id`);

-- idx device_id
CREATE INDEX idx_device_id ON `t_device_code` (`device_id`);

-- idx user_device_code_id
CREATE INDEX idx_user_device_code_id ON `t_device_code` (`user_device_code_id`);

-- idx device_code_expire_time
CREATE INDEX idx_device_code_expire_time ON `t_device_code` (`device_code_expire_time`);

-- t_device_code 新增字段 是否是默认设备名称 0: 不是 1: 是（编辑之后,将会设置为{code: 0}）默认:0
alter table t_device_code
    add default_device_name_status tinyint null default  0 comment '是否是默认设备名称 0: 不是 1: 是（编辑之后,将会设置为{code: 0}）默认:0';



-- t_device 新增字段 virtual_device_id
ALTER TABLE
    `t_device`
    ADD
        COLUMN `virtual_device_id` BIGINT NULL COMMENT '虚拟设备ID(t_user_device_codes.device_id)';
-- idx virtual_device_id
CREATE INDEX idx_virtual_device_id ON `t_device` (`virtual_device_id`);

-- t_device 新增字段 device_code_id
ALTER TABLE
    `t_device`
    ADD
        COLUMN `device_code_id` BIGINT NULL COMMENT '设备码ID(t_device_code.id)';


-- t_user_device_codes 新增字段： 是否走多设备登录逻辑 0: 否 1: 是
ALTER TABLE
    `t_user_device_codes`
    ADD
        COLUMN `is_multi_device_login` TINYINT NOT NULL DEFAULT 0 COMMENT '是否走多设备登录逻辑 0: 否 1: 是';
-- t_user_device_codes 修改 device_code 备注说明
alter table
    t_user_device_codes
    modify
        device_code varchar(10) not null comment '设备码(如果是多设备登录(is_multi_device_login=1)，则设备码详情见 t_device_code 表)';



alter table t_events
    add data_version bigint null comment '数据版本号';

alter table t_meal_plan
    add data_version bigint null comment '数据版本号';

-- 删除不必要的数据
DELETE
FROM t_user_device_codes
WHERE is_delete = 1;