### 查询 缴费通知单/催款涵 历史记录
SELECT bcnh.uuid          AS `发送记录ID`,
       bcnh.email_status  AS `邮件发送状态: 0:失败 1:成功`,
       bcnh.bill_uuid     AS `账单ID`,
       b.bill_code        AS `账单编号`,
       bcnh.contract_uuid AS `合同ID`,
       c.contract_code    AS `合同编号`,
       bcnh.build_name    AS `创建人`,
       bcnh.create_time   AS `创建时间`
FROM bill_charge_notice_history AS bcnh
         INNER JOIN contract AS c ON c.uuid = bcnh.contract_uuid AND c.is_delete = 0 AND c.is_draft = 0
         INNER JOIN bill AS b ON b.uuid = bcnh.bill_uuid AND b.is_delete = 0
WHERE bcnh.build_name = '戴云飞'
  AND bcnh.create_time BETWEEN '2022-12-01 00:00:00' AND '2023-02-01 00:00:00'
  AND bcnh.type = 1
ORDER BY bcnh.email_status DESC, bcnh.create_time DESC;

SELECT
       c.name `公司名称`,
       c.concat AS `联系人名称`,
       ct.contract_code `合同编号`,
       pfsi.project_name `项目名称`,
       pfsi.level_name `楼层名称`,
       pfsi.obj_no `单元编号`,
        ct.create_time `合同创建时间`,
       pur.create_time `租客租赁信息创建时间`
FROM project_unit_rental AS pur
INNER JOIN company AS c ON pur.company_uuid=c.uuid AND c.is_delete=0
LEFT JOIN project_floor_sub_item AS pfsi ON pfsi.uuid= pur.until_uuid AND pfsi.delete_time IS NULL
LEFT JOIN contract AS ct  ON ct.uuid= pur.contract_uuid AND ct.is_delete=0 AND ct.is_draft=0
WHERE pur.company_uuid = '47159b0bf11a447892e37c8cf3ac3888'
  and pur.delete_time is null