### 到访人数据查询
SELECT cc.uuid opportunity_contact_uuid,
       cc.NAME opportunity_contact_name,
       o.uuid  opportunity_uuid,
       o.NAME  opportunity_name,
       cc.phone
FROM company_contacts cc
         JOIN opportunity o ON cc.opportunity_uuid = o.uuid AND o.is_delete = 0
WHERE cc.is_delete = 0
     AND cc.phone='18516698042'
ORDER BY cc.sort, cc.uuid;

##  合同单价和合同单元租金不一致的新建待修改合同信息
SELECT c.contract_code  AS `合同编号`,
       SUM(cu.rent)     AS `合同单元租金总和`,
       ccprs.unit_price AS `合同单价`
FROM contract_unit AS cu
         INNER JOIN contract AS c ON c.uuid = cu.contract_uuid AND c.is_draft = 0
         INNER JOIN contract_clause_pay_rent_setting AS ccprs ON ccprs.contract_uuid = c.uuid AND ccprs.type = 1
WHERE ccprs.is_delete = 0
  AND cu.is_delete = 0
  AND c.contract_status IN (2)
  AND c.project_uuid NOT IN (
                             '31cf853be4424e239dd4748637965ad6',
                             '3936309d0ed14bf7a324d22b0475dfcb',
                             '50bd66a25dfe4489a5d51b9a3dc030e6',
                             '50e593d2093b4a179e8a1aac2d8294f6',
                             '767f8ca2152c42fba8c425241609028a',
                             '8f906e20ce0f4d10b2b0d8c95436fe61'
    )
GROUP BY c.uuid
HAVING SUM(cu.rent) <> `合同单价`;

SELECT
    contract_code AS `合同编号`,
    bill_code AS `账单编号`,
    fee_type AS `费用类型`,
    should_amount AS `应收金额`,
    charging_start_date AS `计费开始日期`,
    charging_end_date AS `计费结束日期`,
    pay_date AS `付款日期`,
    create_time AS `创建时间`,
    bill_uuid AS `账单UUID`,
    add_bills_manually,
    is_delete
    FROM bill_item
WHERE contract_code='HT-CQS-GJZXT1-2705-07-202302-1368'
AND fee_type ='滞纳金';