# 新增 会员卡审核人管理菜单
INSERT INTO menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
VALUES ('1211e86393644d32a780c46968a0b9bd', 846782090753224704, '会员卡审核人管理', '9ca04e9509fe11ecbf1c00163e0434b9',
        13, DEFAULT, DEFAULT, '/chain-manage/member-audit-manage', 1, DEFAULT);
# 管理员角色新增 会员卡审核人管理 菜单权限
INSERT INTO group_menus (menu_uuid, group_uuid, create_time, update_time)
VALUES ('1211e86393644d32a780c46968a0b9bd', '3', DEFAULT, DEFAULT);

## 会员卡审核人管理 子菜单 新增、编辑、删除
INSERT INTO menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
VALUES ('da98c1da2ac3448ba33dd3b93e7d2bc5', 846782090753224704, '新增', '1211e86393644d32a780c46968a0b9bd', 1, DEFAULT,
        DEFAULT, '/chain-manage/member-audit-manage/form?type=add', 1, DEFAULT);

INSERT INTO menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
VALUES ('ccaf3277fa6d45aab9b2c1af9dec6cd6', 846782090753224704, '编辑', '1211e86393644d32a780c46968a0b9bd', 2, DEFAULT,
        DEFAULT, '/chain-manage/member-audit-manage/form?type=edit', 1, DEFAULT);

INSERT INTO menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
VALUES ('8b66d7eb86d74adcb92c53ea6b867216', 846782090753224704, '删除', '1211e86393644d32a780c46968a0b9bd', 3, DEFAULT,
        DEFAULT, DEFAULT, 1, DEFAULT);

## 管理员角色新增 会员卡审核人管理 子菜单 新增、编辑、删除 菜单权限
INSERT INTO group_menus (menu_uuid, group_uuid, create_time, update_time)
VALUES ('da98c1da2ac3448ba33dd3b93e7d2bc5', '3', DEFAULT, DEFAULT);
INSERT INTO group_menus (menu_uuid, group_uuid, create_time, update_time)
VALUES ('ccaf3277fa6d45aab9b2c1af9dec6cd6', '3', DEFAULT, DEFAULT);
INSERT INTO group_menus (menu_uuid, group_uuid, create_time, update_time)
VALUES ('8b66d7eb86d74adcb92c53ea6b867216', '3', DEFAULT, DEFAULT);

#用户审核人管理 表
CREATE TABLE user_approval_template (
  user_approval_template_uuid             BIGINT  NOT NULL  COMMENT '主键ID',
  template_name  VARCHAR(200)    NOT NULL COMMENT '模板名称',
  level_count    TINYINT         NOT NULL  COMMENT '1:仅一级 2:一级+二级',
  create_time     TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  update_time    TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (user_approval_template_uuid)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户审批模板';

CREATE TABLE user_approval_level_admin (
  user_approval_level_admin_uuid             BIGINT UNSIGNED NOT NULL  COMMENT '主键ID',
  user_approval_template_uuid    BIGINT  NOT NULL COMMENT '模板ID',
  level_no       TINYINT         NOT NULL COMMENT '级别: 1/2',
  admin_uuid      BIGINT  NOT NULL COMMENT '审批人(admin.uuid)',
  create_time     TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (user_approval_level_admin_uuid),
  UNIQUE KEY uk_member_once (user_approval_template_uuid, admin_uuid, level_no)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户审批人员表';


CREATE TABLE user_approval_template_store (
  user_approval_template_store_uuid BIGINT  NOT NULL COMMENT '主键ID',
  user_approval_template_uuid   BIGINT UNSIGNED NOT NULL COMMENT '模板ID user_approval_template.user_approval_template_uuid',
  store_uuid      BIGINT  NOT NULL COMMENT '门店ID store.uuid',
  create_time    TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (user_approval_template_store_uuid),
  UNIQUE KEY uk_tpl_store (user_approval_template_uuid, store_uuid),
  KEY idx_store_uuid (store_uuid)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户审核模板适用门店表';


