# 已经线上环境执行当前 SQL 执行时间: 2020 07/01  10:12
DROP TABLE IF EXISTS unit_rental_record;
CREATE TABLE IF NOT EXISTS unit_rental_record
(
    uuid                  bigint(19)                         not null comment '主键uuid'
        primary key,
    region_uuid           varchar(32)                        null comment 'region uuid(城市)',
    region_name           varchar(50)                        null comment '所属城市名',
    project_uuid          varchar(32)                        not null comment '项目id',
    project_name          varchar(255)                       null comment '项目名字',
    building_uuid         varchar(32)                        not null comment '楼层id',
    building_name         varchar(255)                       null comment '楼层名字',
    sub_item_uuid         varchar(50)                        not null comment '单元uuid',
    obj_no                varchar(50)                        null comment '单元号，套间号 ， 工位号',
    type                  int(1)                             null comment '单元0   套间1  工位2',
    contract_area         decimal(20, 2)                     not null comment '出租面积 (合同面积)',
    rent_calculation_area decimal(20, 2)                     not null comment '租赁面积 (租赁面积)',
    unit_type             int(1)                             not null comment '单元类型: 1:标准间(高端商务办公) 2:创客空间',
    business_uuid         varchar(64)                        not null comment '业务uuid 其取值含义是  business_type 对应',
    business_type         int(1)                             not null comment '业务类型: 1:合同 在系统内是一个枚举',
    record_status         int(1)                             null default 1 comment '记录状态:  1:有效的 2:无效的 default: 1 在系统内是一个枚举',
    lease_start_date      date                               not null comment '租赁起始日期',
    lease_end_date        date                               not null comment '租赁结束日期',
    lease_days            int(2)                             not null comment '租赁天数',
    create_time           datetime default CURRENT_TIMESTAMP null comment '创建时间',
    update_time           datetime default CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP comment '修改时间'
) COMMENT '单元出租统计';

create index unit_rental_record_building_uuid_index
    on unit_rental_record (building_uuid);

create index unit_rental_record_business_uuid_business_type_index
    on unit_rental_record (business_uuid, business_type);

create index unit_rental_record_lease_end_date_index
    on unit_rental_record (lease_end_date);

create index unit_rental_record_lease_start_date_lease_end_date_index
    on unit_rental_record (lease_start_date, lease_end_date);

create index region_uuid_project_uuid_building_uuid_obj_no_index
    on unit_rental_record (region_uuid, project_uuid, building_uuid, obj_no);