-- table: 第三方日历邀请人信息
CREATE TABLE `t_third_sync_calendar_inviter` (
    `id` BIGINT NOT NULL '主键',
    `device_id`  BIGINT NOT NULL '设备ID',
    `event_id`  BIGINT NOT NULL '事项ID',
    `event_source`  TINYINT NOT NULL '事项来源 0:webcal 1:google 2:outlook',
    `sync_calendar_id`  VARCHAR(300)  NULL '第三方日历ID',
    `sync_event_id`  VARCHAR(230) NULL '同步事项ID',
    `inviter_info`  VARCHAR(230) NOT NULL '邀请人信息',
    `inviter_email`  VARCHAR(230)  NULL '邀请人邮箱',
    `inviter_name`  VARCHAR(50)  NULL '邀请人姓名',
    `inviter_ext_info`  VARCHAR(500) NULL '邀请人拓展信息',
    `webcal_participation_status`  TINYINT  NULL 'webcal participation status: 0:NONE  1:ACCEPTED (已接受) 2:DECLINED (已拒绝) 3:TENTATIVE (暂定) 4:DELEGATED (已委派) 5:NEEDS-ACTION (需要操作) 6:IN-PROCESS (处理中) 7:COMPLETED (已完成)',
    `google_participation_status`  TINYINT  NULL 'google participation status: 0:NONE  1:needsAction(参加者尚未回复邀请（建议针对新活动使用） 2:declined(参加者已拒绝邀请) 3:tentative(参加者已暂时接受邀请) 4:accepted(参加者已接受邀请)',
    `outlook_participation_status`  TINYINT  NULL 'outlook participation status: 0:None 1:Organizer 2:TentativelyAccepted 3:Accepted 4:Declined 5:NotResponded',
    `create_time`  DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP '创建时间',
    `update_time`  DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB  COMMENT='第三方日历邀请人信息';

-- idx: device_id_event_id  
CREATE INDEX `idx_device_id_event_id` ON `t_third_sync_calendar_inviter` (`device_id`, `event_id`);
-- idx: sync_calendar_id
CREATE INDEX `idx_sync_calendar_id` ON `t_third_sync_calendar_inviter` (`sync_calendar_id`);
-- idx: sync_event_id
CREATE INDEX `idx_sync_event_id` ON `t_third_sync_calendar_inviter` (`sync_event_id`);