CREATE TABLE `business_cooperation`
(
    `uuid`         bigint(19)                                                    NOT NULL COMMENT '主键uuid',
    `subject_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '项目名称',
    `subject_text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci         NULL COMMENT '合作详情',
    `images`       varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '图片url',
    `phone`        char(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci     NULL DEFAULT NULL COMMENT '咨询电话',
    `create_uuid`  char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci     NULL DEFAULT NULL COMMENT '创建人',
    `update_uuid`  char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci     NULL DEFAULT NULL COMMENT '修改人',
    `create_time`  datetime                                                           DEFAULT CURRENT_TIMESTAMP NULL COMMENT '创建时间',
    `update_time`  datetime                                                           DEFAULT CURRENT_TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    `is_delete`    int(1)                                                        NULL DEFAULT 0 COMMENT '是否删除：0 未删，1 已删',
    PRIMARY KEY (`uuid`) USING BTREE
) ENGINE = InnoDB
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_unicode_ci COMMENT = '业务合作详情表'
  ROW_FORMAT = Compact;
CREATE TABLE `business_cooperation_consult`
(
    `uuid`          bigint(19)                                                    NOT NULL COMMENT '主键uuid',
    `customer_name` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci  NULL DEFAULT NULL COMMENT '客户姓名',
    `phone`         varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci  NULL DEFAULT NULL COMMENT '客户手机号',
    `text`          varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '备注',
    `create_time`   datetime                                                           DEFAULT CURRENT_TIMESTAMP NULL COMMENT '咨询时间(创建时间)',
    `status`        int(1)                                                        NULL DEFAULT 0 COMMENT '状态：0 未禁用，1 禁用',
    `is_delete`     int(1)                                                        NULL DEFAULT 0 COMMENT '是否删除：0 未删，1 已删',

    PRIMARY KEY (`uuid`) USING BTREE
) ENGINE = InnoDB
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_unicode_ci COMMENT = '业务合作咨询表'
  ROW_FORMAT = Compact;
