create table t_app_task_firebase_notification_records (
    firebase_notification_id bigint not null primary key comment 'Firebase通知记录ID',
    user_id bigint not null comment '用户ID',
    device_id bigint not null comment '设备ID',
    origin_event_id bigint not null comment '任务ID',
    start_datetime datetime null comment '任务开始时间(UTC+0)',
    start_date date null comment '开始日期',
    start_time time null comment '开始时间',
    sent_datetime datetime(3) not null comment '通知发送时间(UTC+0)',
    create_time datetime default CURRENT_TIMESTAMP not null comment '创建时间，插入时自动更新',
    update_time datetime default CURRENT_TIMESTAMP not null on update CURRENT_TIMESTAMP comment '更新时间，插入和更新时自动更新'
) comment '任务Firebase通知记录表';

create index idc_start_datetime on t_app_task_firebase_notification_records (start_datetime);

create index idx_device_id on t_app_task_firebase_notification_records (device_id);

create index idx_origin_event_id on t_app_task_firebase_notification_records (origin_event_id);

create index idx_sent_datetime on t_app_task_firebase_notification_records (sent_datetime);

create index idx_user_id
    on t_app_task_firebase_notification_records (user_id);

create index idx_business_id on t_user_push_log (business_id);