alter table t_third_party_calendar_list
    add next_sync_token varchar(200) null comment 'Google增量查询 nextSyncToken';



create table t_google_calendar_notification_retry
(
    id                              bigint                             not null comment 'ID'
        primary key,
    channel_id                      varchar(200) charset utf8mb4       not null comment 'X-Goog-Channel-ID %d-%d deviceId#thirdPartyCalendarAuthId',
    device_id                       bigint                             null comment 'device id',
    third_party_calendar_auth_id    bigint                             null comment 'thirdPartyCalendarAuthId',
    resource_id                     varchar(200) charset utf8mb4       not null comment 'Google Resource ID calendarId',
    resource_state                  varchar(32) charset utf8mb4        not null comment 'Resource State',
    message_number                  bigint                             not null comment 'Message Number',
    resource_uri                    varchar(512) charset utf8mb4       not null comment 'Resource URI',
    token                           varchar(256) charset utf8mb4       null comment 'Channel Token',
    expiration                      varchar(50) charset utf8mb4        null comment 'Channel Expiration',
    error_count                     int                                not null default 0 comment 'Error Count',
    google_calendar_notification_id bigint                             null comment 'Google Calendar Notification ID',
    create_time                     datetime default CURRENT_TIMESTAMP not null comment 'Create Time'
)
    comment 'Google Calendar Notification Retry';

# channel_id unique index
create unique index idx_channel_id
    on t_google_calendar_notification_retry (channel_id);

create index idx_channel_id_resource_id
    on t_google_calendar_notification_retry (channel_id, resource_id);

create index idx_create_time
    on t_google_calendar_notification_retry (create_time);

create index idx_device_id_third_party_calendar_auth_id
    on t_google_calendar_notification_retry (device_id, third_party_calendar_auth_id);

create index idx_third_party_calendar_auth_id
    on t_google_calendar_notification_retry (third_party_calendar_auth_id);