alter table sys_user
    modify user_type tinyint(1) default 0 null comment '用户类型 0:pc端:sys_user 1:pc端:org_sys_user default:0';

create index t_device_group_device_group_code_index
    on t_device_group (device_group_code);

create index t_device_group_device_group_key_index
    on t_device_group (device_group_key);

create index t_device_group_org_id_index
    on t_device_group (org_id);


create index t_business_description_business_id_business_type_index
    on t_business_description (business_id, business_type);

create index t_business_description_language_type_index
    on t_business_description (language_type);

create index idx_sync_class_pass
    on store_course (sync_class_pass);

alter table t_business_description
    add business_extend_id bigint null comment '业务拓展ID etc.同一个题目的不同语言版本的 extId 相同';

alter table t_business_description
    add sort int null comment '排序 从小到大排序';

alter table t_questionnaire
    add business_extend_id bigint null comment '业务拓展ID etc.同一个题目的不同语言版本的 extId 相同';

alter table t_questionnaire
    add sort int default 0 null comment '排序';

alter table t_user_questionnaire
    change t_user_questionnaire_id user_questionnaire_id bigint not null comment '用户问卷ID';

alter table t_user
    add phone varchar(50) null comment '用户手机号';

alter table t_list
    add is_built_in tinyint(1) default 0 null comment '是否内置清单 0:否 1:是(内置清单不可删除)';

alter table t_list
    add is_edited tinyint(1) default 0 null comment '内建清单是否已经编辑 0:否 1:是(仅有内建清单此字段才有意义，用户自建清单不需要)';

alter table t_user_calendar_categories
    modify category_type tinyint(1) default 0 not null comment ' 类别分类：0 表示事项，1 表示杂物(杂物来源于事项,如果类别为杂物类别，则类别也属于事项分类) 2:晚餐计划。';


alter table t_events
    add start_date_time datetime null comment '事项开始时间(UTC+0)' after is_all_day;

alter table t_events
    add end_date_time datetime null comment '事项结束时间(UTC+0)' after start_time;

alter table t_event_recurrence_rules
    add recurrence_end_datetime datetime null comment '重复事项截止日期(UTC+0)' after recurrence_end_date;

alter table t_events
    change start_date_time start_datetime datetime null comment '事项开始时间(UTC+0)';

alter table t_events
    change end_date_time end_datetime datetime null comment '事项结束时间(UTC+0)';

alter table t_events
    add origin_event_start_datetime datetime null comment '原始事项开始时间(UTC+0)' after origin_event_recurrence_rules_id;

alter table t_events
    add origin_event_end_datetime datetime null comment '原始事项结束时间(UTC+0)' after origin_start_time;


alter table t_events
    add completed_time datetime null comment '(杂项)完成时间 UTC+0';

alter table t_events
    add is_from_parse_ics tinyint(1) default 0 null comment '是否来源于解析: ics 协议文件 0-否 1-是';

alter table t_events
    add sync_email varchar(200) null comment '同步的邮箱';

alter table sys_oper_log
    modify method text null comment '方法名称';

alter table sys_oper_log
    modify request_method text null comment '请求方式';

alter table sys_oper_log
    modify oper_url text null comment '请求URL';

alter table sys_oper_log
    modify oper_param text null comment '请求参数';

alter table sys_oper_log
    modify json_result text null comment '返回参数';

alter table sys_oper_log
    modify error_msg text null comment '错误消息';

alter table t_user
    add is_first_create_device tinyint(1) default 0 null comment ' 是否首次创建设备 0:否 1:是 2:二次请求设备列表 isFirstCreateDevice=1 设置为 2 为了定位接口逻辑是否正确，如果出现问题话, default 0';





