# alter table t_event_recurrence_rules
#     modify event_type tinyint(1) not null comment '事项类型：0 表示事项，1 表示晚餐计划，2 表示杂物 3 餐食计划';
#
# alter table t_event_recurrence_rules
#     modify event_id bigint not null comment '事项或晚餐计ID或餐食计划ID';
#
# CREATE TABLE `t_meal_category` (
#     `meal_category_id` bigint NOT NULL COMMENT '主键ID',
#     `device_id` bigint NOT NULL COMMENT '设备ID',
#     `category_name` varchar(200) NOT NULL COMMENT '分类名称',
#     `original_category_name` varchar(200) DEFAULT NULL COMMENT '原始分类名称',
#     `category_color` varchar(20) NOT NULL COMMENT '分类颜色',
#     `category_priority` int DEFAULT 1 COMMENT '分类优先级,越小越优先',
#     `is_hide` tinyint DEFAULT 0 COMMENT '是否隐藏 0:否 1:是',
#     `is_delete` tinyint DEFAULT 0 COMMENT '是否删除 0:否 1:是',
#     `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
#     `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
#     PRIMARY KEY (`meal_category_id`),
#     KEY `idx_device_id` (`device_id`) COMMENT '设备ID索引',
#     KEY `idx_category_name` (`category_name`) COMMENT '分类名称索引',
#     KEY `idx_device_id_category_name` (`device_id`, `category_name`) COMMENT '设备ID和分类名称联合索引'
# ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '餐食分类表';
#
# CREATE TABLE `t_meal_recipe` (
#     `meal_recipe_id` bigint NOT NULL COMMENT '主键ID',
#     `device_id` bigint NOT NULL COMMENT '设备ID',
#     `meal_category_id` bigint NOT NULL COMMENT '食谱分类ID',
#     `recipe_name` varchar(300) NOT NULL COMMENT '食谱名称',
#     `recipe_desc` text DEFAULT NULL COMMENT '食谱描述',
#     `is_delete` tinyint DEFAULT 0 COMMENT '是否删除 0:否 1:是',
#     `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
#     `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
#     PRIMARY KEY (`meal_recipe_id`),
#     KEY `idx_device_id` (`device_id`) COMMENT '设备ID索引',
#     KEY `idx_meal_category_id` (`meal_category_id`) COMMENT '分类ID索引',
#     KEY `idx_recipe_name` (`recipe_name`) COMMENT '食谱名称索引'
# ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '食谱表';
#
# CREATE TABLE `t_meal_plan` (
#     `meal_plan_id` bigint NOT NULL COMMENT '主键ID',
#     `device_id` bigint NOT NULL COMMENT '设备ID',
#     `meal_recipe_id` bigint NOT NULL COMMENT '食谱ID',
#     `event_recurrence_rules_id` bigint DEFAULT NULL COMMENT '重复规则ID',
#     `meal_date_time` datetime NOT NULL COMMENT '餐食日期时间',
#     `meal_date` date NOT NULL COMMENT '餐食日期',
#     `meal_time` time NOT NULL COMMENT '餐食时间',
#     `meal_remark` text DEFAULT NULL COMMENT '餐食备注',
#     `rrule` varchar(500) DEFAULT NULL COMMENT '重复事项重复规则(RFC 5545)',
#     `exdate` text DEFAULT NULL COMMENT '重复事项排除日期(RFC 5545)',
#     `add_zone` tinyint DEFAULT NULL COMMENT '添加的时区(UTC+x)',
#     `is_delete` tinyint DEFAULT 0 COMMENT '是否删除 0:否 1:是',
#     `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
#     `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
#     PRIMARY KEY (`meal_plan_id`),
#     KEY `idx_device_id` (`device_id`) COMMENT '设备ID索引',
#     KEY `idx_recipe_id` (`meal_recipe_id`) COMMENT '食谱ID索引',
#     KEY `idx_date_time` (`meal_date_time`) COMMENT '餐食日期时间索引',
#     KEY `idx_date` (`meal_date`) COMMENT '餐食日期索引'
# ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '餐食计划表';
#
# CREATE TABLE `t_meal_plan_user` (
#     `meal_plan_user_id` bigint NOT NULL COMMENT '主键ID',
#     `meal_plan_id` bigint NOT NULL COMMENT '餐食计划ID',
#     `user_id` bigint NOT NULL COMMENT '用户ID',
#     `is_creator` tinyint DEFAULT 0 COMMENT '是否是创建者 0:否 1:是',
#     PRIMARY KEY (`meal_plan_user_id`),
#     UNIQUE KEY `uk_plan_user` (`meal_plan_id`, `user_id`) COMMENT '计划用户唯一索引',
#     KEY `idx_user_id` (`user_id`) COMMENT '用户ID索引'
# ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '餐食计划用户表';
#
# alter table t_meal_plan
#     add is_recurring tinyint default 0 null comment '是否重复：0 表示否，1 表示是。' after meal_remark;
#
# alter table t_meal_plan
#     add meal_category_id BIGINT null comment '食谱分类ID' after meal_recipe_id;
#
# create index t_meal_plan_meal_category_id_index
#     on t_meal_plan (meal_category_id);
#
# alter table t_meal_category
#     modify category_name varchar(300) not null comment '分类名称';
#
# alter table t_meal_category
#     modify original_category_name varchar(300) null comment '原始分类名称';
#
# alter table t_meal_recipe
#     modify recipe_name varchar(400) not null comment '食谱名称';
#
#
#
# 2024011515:54
