SELECT uuid, name, concat
FROM company
WHERE invite_code IN (
                      275060,
                      478088,
                      033493,
                      730378,
                      883756,
                      345935,
                      600897,
                      535432,
                      857526,
                      010255,
                      798210,
                      017688,
                      550507,
                      529928,
                      400442,
                      429380
    );

## 删除 合同,合同单元信息
UPDATE
    contract AS c INNER JOIN contract_company AS cc
        ON c.uuid = cc.contract_uuid
        INNER JOIN company AS cm ON cm.uuid = cc.company_uuid
        INNER JOIN contract_unit AS cu ON cu.contract_uuid = c.uuid
SET c.is_delete=1,
    c.updater_name = '20220914:清除线上数据',
    cu.is_delete=1
WHERE cm.invite_code
          IN (
              275060,
              478088,
              033493,
              730378,
              883756,
              345935,
              600897,
              535432,
              857526,
              010255,
              798210,
              017688,
              550507,
              529928,
              400442,
              429380
          );
## 删除 账单主表 bill  bill-item
UPDATE bill AS b
    INNER JOIN bill_item AS bi ON b.uuid = bi.bill_uuid AND bi.is_delete = 0
SET b.is_delete=1,
    b.update_uuid='20220914',
    bi.is_delete=1,
    bi.update_uuid='20220914'
WHERE b.is_delete = 0
  AND b.contract_uuid IN (SELECT uuid
                          FROM contract
                          WHERE updater_name = '20220914:清除线上数据'
                            AND is_delete = 1);
## 服务前置化
DELETE
FROM notification_instruments_sending_statistics
WHERE company_uuid IN (SELECT uuid
                       FROM company
                       WHERE invite_code IN (
                                             275060,
                                             478088,
                                             033493,
                                             730378,
                                             883756,
                                             345935,
                                             600897,
                                             535432,
                                             857526,
                                             010255,
                                             798210,
                                             017688,
                                             550507,
                                             529928,
                                             400442,
                                             429380
                           )
);
DELETE
FROM notification_instruments_record
WHERE company_uuid IN (SELECT uuid
                       FROM company
                       WHERE invite_code IN (
                                             275060,
                                             478088,
                                             033493,
                                             730378,
                                             883756,
                                             345935,
                                             600897,
                                             535432,
                                             857526,
                                             010255,
                                             798210,
                                             017688,
                                             550507,
                                             529928,
                                             400442,
                                             429380
                           )
);

