# CREATE TABLE `api_client_credentials`
# (
#     `id`            BIGINT       NOT NULL AUTO_INCREMENT COMMENT '唯一标识符',
#     `grant_type`    TINYINT      NOT NULL COMMENT '授权类型，0:表示cp',
#     `client_id`     CHAR(32)     NOT NULL COMMENT '客户端ID',
#     `client_secret` VARCHAR(150) NOT NULL COMMENT '客户端秘钥',
#     `type`          TINYINT DEFAULT 0 COMMENT '令牌类型，0:表示bearer',
#     PRIMARY KEY (`id`)
# ) ENGINE = InnoDB
#   DEFAULT CHARSET = utf8mb4 COMMENT ='API客户端认证信息表';
#
# create index idx_client_id
#     on api_client_credentials (client_id);
#
# alter table user
#     add member_registration_source tinyint(1) default 0 null comment '会员注册来源 0:拉伽 1:ClassPath小程序 default 0';
#
# alter table user
#     alter column birthday_type set default 0;
#
# alter table store_course
#     add course_id VARCHAR(50) null comment '课程ID 用于和 ClassPass 交互使用';
#
# create index idx_course_id
#     on store_course (course_id);
#
# alter table store_schedules
#     add cp_size int default 0 null comment '开放CP固定席位(人)' after size;
#
#
# alter table user_card_subscribe_logs
#     add reservation_source tinyint(1) default 0 null comment '预约来源 0:拉伽 1:ClassPass小程序 默认:0';
#
# alter table user_card_subscribe_logs
#     add reservation_tag tinyint(1) default 0 null comment '预约标签 0:无标签 1:CP 默认:0';
#
# create index idx_schedules_uuid_course_uuid
#     on user_card_subscribe_logs (schedules_uuid, course_uuid);
#
# create index idx_status_reservation_source
#     on user_card_subscribe_logs (status, reservation_source);
#
# create index idx_course_uuid
#     on store_schedules (course_uuid);
#
# create index idx_staff_uuid
#     on store_schedules (staff_uuid);
#
# alter table user
#     modify phone varchar(50) not null comment '手机号';
#
# alter table user
#     add cp_user_id varchar(100) null comment 'cp user id (class pass user id)';
#
# create index idx_cp_user_id
#     on user (cp_user_id);
#
# create index idx_phone
#     on user (phone);
#
# alter table user_card_subscribe_logs
#     add cp_booking_id varchar(100) null comment 'class pass booking id';
#
# create index idx_cp_booking_id
#     on user_card_subscribe_logs (cp_booking_id);
#
# alter table user_card_subscribe_logs
#     modify user_phone varchar(50) null comment '用户手机号';
#
#
# create index idx_subscribe_uuid
#     on subscribe_operate_logs (subscribe_uuid);
#
# alter table subscribe_operate_logs
#     add operation_source tinyint(1) default 0 null comment '操作来源 0:拉伽 1:ClassPass小程序';
#
# create index salesman_recommend_user_user_uuid_index
#     on salesman_recommend_user (user_uuid);
#
# create index idx_store_uuid
#     on user_return_visit (store_uuid);
#
# alter table store
#     add store_id varchar(50) default null null comment '场馆 id 若需要在ClassPath中进行排课则需要必填场馆ID';
#
# UPDATE store
# SET store_id=uuid
# WHERE store_id is null;
#
# create index idx_store_uuid
#     on store_schedules (store_uuid);
#
# create index idx_store_uuid
#     on user_card_subscribe_logs (store_uuid);
#
#
# alter table store
#     add sync_class_pass tinyint(1) default 0 null comment '是否将场馆信息同步到ClassPass 0:不同步 1:同步 默认 0';
#
# alter table store_course
#     add sync_class_pass tinyint(1) default 0 null comment '是否将课程信息信息同步到ClassPass 0:不同步 1:同步 默认 0';
#
#
# alter table common_course
#     add sync_class_pass tinyint(1) default 0 null comment '是否将场馆信息同步到ClassPass 0:不同步 1:同步 默认 0';
#

# # 新增菜单按钮: 设置CP固定席位
# INSERT menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
# values ('c628e0c0fff04b24af48086330329829', '846782090753224704', '设置CP固定席位', '5f96031803ed11ecbf1c00163e0434b9',
#         4, now(), now(), '', '2', null);


# alter table common_course
#     add is_big_equipment tinyint(1) default 0 null comment '是否是大器械小班级 0:否 1:是';
#
# alter table store_course
#     add is_big_equipment tinyint(1) default 0 null comment '是否是大器械小班级 0:否 1:是';


# INSERT  group_menus (menu_uuid, group_uuid) VALUES ('c628e0c0fff04b24af48086330329829', 'd8ffd9bfc1364d36aee69787cc27ba03');

# 预约人次改成小数
# alter table user_card_brush_logs
#     modify number decimal(10, 2) null comment '本次预约人次';
#
# # 会员表新增字段
# alter table user
#     add wechat_tag varchar(80) null comment ' 微信标签 限制50个字以内';
#
# alter table user
#     add wechat_number varchar(80) null comment '微信号 限制50个字以内';
#
# alter table user
#     add member_level tinyint(1) null comment '会员等级 0:A级(私教) 1:B级(团课)';
#
#
# CREATE TABLE member_extension_info (
#     member_extension_info_id BIGINT  COMMENT '主键ID，使用雪花算法生成',
#     user_uuid BIGINT NOT NULL COMMENT '用户UUID，用于与user表关联',
#     marital_status VARCHAR(100) COMMENT '婚姻状况',
#     mouth VARCHAR(100) COMMENT '忌口',
#     preference VARCHAR(100) COMMENT '偏好',
#     course_frequency VARCHAR(100) COMMENT '课程频率',
#     experience_teacher VARCHAR(100) COMMENT '体验老师',
#     body_evaluation VARCHAR(100) COMMENT '体测评估',
#     dining_preference VARCHAR(100) COMMENT '餐食爱好',
#     menstrual_period VARCHAR(100) COMMENT '生理期',
#     request VARCHAR(100) COMMENT '诉求',
#     experience_course VARCHAR(100) COMMENT '体验课',
#     intention_card_item VARCHAR(100) COMMENT '意向卡项',
#     course_planning TEXT COMMENT '课程规划',
#     PRIMARY KEY (member_extension_info_id)
# ) COMMENT='会员拓展信息表';
#
# create index member_extension_info_user_uuid_index
#     on member_extension_info (user_uuid);
#
# drop index member_extension_info_user_uuid_index on member_extension_info;
#
# alter table member_extension_info
#     add constraint member_extension_info_pk
#         unique (user_uuid);
#
# alter table user_card
#     add coach_name varchar(30) null comment '授课教练名称 store_staff#name';
#
# alter table user_card
#     add coach_uuid BIGINT null comment '授课教练uuid store_staff#uuid';
#
#
#
# CREATE TABLE `user_card_fee_extension` (
#     `user_card_fee_extension_id` BIGINT NOT NULL COMMENT '会员卡费用拓展信息ID，使用雪花算法生成',
#     `user_card_uuid` BIGINT NOT NULL COMMENT '会员卡UUID',
#     `coach_uuid` BIGINT NOT NULL COMMENT '教练UUID store_staff#uuid',
#     `coach_name` VARCHAR(30) NOT NULL COMMENT '教练名称 store_staff#name',
#     `mobile` VARCHAR(20)  NULL COMMENT '教练手机号',
#     `gender` TINYINT(1)  NULL COMMENT '教练性别 1男2女;3-未知',
#     `coach_commission_rate` DECIMAL(5, 2) NOT NULL COMMENT '教练提成比例，单位为百分比',
#     `coach_commission_amount` DECIMAL(10, 2) NOT NULL COMMENT '教练提成金额',
#     `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
#     `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '记录更新时间',
#     PRIMARY KEY (`user_card_fee_extension_id`),
#     INDEX `idx_member_card_uuid` (`user_card_uuid`),
#     INDEX `idx_coach_uuid` (`coach_uuid`)
# ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员卡费用拓展信息表';
#
# alter table user_card
#     add upload_voucher text null comment '上传凭证';
#
# alter table store
#     add user_show_status tinyint(1) default 1 null comment '用户端显示状态 0:不显示 1:显示 默认 1';
#
# alter table store
#     add card_audit_status tinyint(1) default 1 null comment '会员卡审核状态 0:不审核 1:审核  默认 1';
#
# -- 表：user_card_audit_log
# -- 会员卡审核记录
#
# CREATE TABLE user_card_audit_log
# (
#     user_card_audit_log_id BIGINT PRIMARY KEY COMMENT '会员卡审核记录ID，采用雪花算法生成',
#     user_id                BIGINT                             NOT NULL COMMENT '用户ID',
#     user_card_uuid         BIGINT                             NOT NULL COMMENT '用户卡UUID',
#     record_id              BIGINT                             NOT NULL COMMENT '记录ID，同一条审核记录ID相同',
#     step                   TINYINT                            NOT NULL COMMENT '审核步骤:0:待审核，2:审核通过，3:审核拒绝',
#     remarks                VARCHAR(200) COMMENT '备注',
#     operate_time           DATETIME                           NULL COMMENT '操作时间',
#     operate_uuid           CHAR(36)                           NOT NULL COMMENT '操作人UUID',
#     operate_name           VARCHAR(255)                       NOT NULL COMMENT '操作人名称',
#     create_time            datetime default CURRENT_TIMESTAMP null COMMENT '创建时间',
#     update_time            datetime default CURRENT_TIMESTAMP null on update CURRENT_TIMESTAMP COMMENT '更新时间'
# ) COMMENT ='会员卡审核记录表';
#
#
# alter table user_card
#     add audit_status tinyint(1) default 1 null comment '审核状态枚举: 0:待审核，1:审核通过，2:审核驳回 3:已撤销 default:1';
#
# alter table user_card_audit_log
#     modify step tinyint not null comment ' 审核步骤: 0:待审核，1:已撤销 2:审核通过，3:审核拒绝。';
#
# alter table user_card
#     add audit_record_id BIGINT null comment '当前审核记录ID';
#
# create index user_card_audit_log_record_id_index
#     on user_card_audit_log (record_id);
#
# alter table user_card_change_logs
#     modify operation_type tinyint(1) default 1 null comment '卡操作类型，1：发卡，2；开卡，3：请假，4：退卡，5：补卡，6：挂失，7：续卡，8：转卡，9：解挂，10：停卡，11：解除停卡，12：卡升级 13:(会员卡)待审核，14:(会员卡)审核通过，15:(会员卡)审核驳回 16:(会员卡)已撤销';
#
#
# alter table user_card_change_logs
#     add record_id BIGINT null comment '会员卡记录ID，同一条审核记录ID相同。';
#
# alter table user_card_change_logs
#     add step tinyint null comment '会员卡审核步骤: 0:待审核，1:已撤销 2:审核通过，3:审核拒绝。';
#
# alter table user_card_change_logs
#     add remarks varchar(200) null comment '会员卡审核备注';
#
#
#
#
# -- 使用雪花算法生成的主键
# CREATE TABLE user_management_records (
#     member_management_records_id BIGINT PRIMARY KEY COMMENT '主键ID',
#     `year` INT NOT NULL COMMENT '年',
#     `month` TINYINT NOT NULL COMMENT '月',
#     year_month_str VARCHAR(7) NOT NULL COMMENT '年月',
#     reservation_count INT NOT NULL COMMENT '预约次数',
#     checkin_count INT NOT NULL COMMENT '签到次数',
#     weight DECIMAL(5,2) NOT NULL COMMENT '体重(kg)',
#     notes text  COMMENT '备注',
#     create_time DATETIME DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
#     update_time DATETIME NULL COMMENT '最新编辑时间',
#     user_uuid BIGINT NOT NULL COMMENT '用户UUID'
# ) COMMENT='用户管理记录表';
#
# create index user_management_records_month_index
#     on user_management_records (month);
#
# create index user_management_records_user_uuid_index
#     on user_management_records (user_uuid);
#
# create index user_management_records_year_index
#     on user_management_records (year);
#
#
# alter table user_management_records
#     modify reservation_count int default 0 null comment '预约次数';
#
# alter table user_management_records
#     modify checkin_count int default 0 null comment '签到次数';
#
# alter table user_management_records
#     modify weight decimal(5, 2) null comment '体重(kg)';
#
# alter table user
#     modify member_level tinyint(1) null comment '会员等级 0:A级 1:B级 2:C级';
#
# alter table `groups`
#     add  store_menu_uuid_list text null comment '门店系统菜单uuid 数组';
#
#
# alter table `groups`
#     modify group_type tinyint(1) null comment '角色类型 0-超级管理员 1-教练；2-店长；3-前台；4-跟进教练；5-分销员；6-其他';
#
# alter table user_third_auth
#     modify user_type tinyint(1) default 1 null comment '用户类型：1-用户；2-教练 3-管理员';
#
#
# alter table admin
#     add code char(32) null comment '用户唯一编码,等同于 uuid';
#
# create index admin_code_index
#     on admin (code);
#
# alter table user_card
#     add validity_num int default 0 null comment '开卡有效期值';
#
# alter table user_card
#     add validity_unit int null comment '开卡有效期单位 0:天 1:月';
#
# UPDATE `groups`
# SET name='跟进教练'
# WHERE name='会籍顾问';
#
# alter table user_card_audit_log
#     modify remarks text null comment '备注';
#
#
# alter table user_card_change_logs
#     modify remark text null comment '备注';
#
# alter table user_card
#     add audit_time datetime null comment '发起审核时间';
#
# alter table user_card_change_logs
#     modify remarks text null comment '会员卡审核备注';
#
#
# create index admin_store_relation_store_uuid_index
#     on admin_store_relation (store_uuid);
#
#
# alter table user_card
#     add last_audit_user_card_uuid bigint null comment '上次审核会员卡uuid';
#
#
# alter table user_card
#     drop column validity_num;
#
# alter table user_card
#     drop column validity_unit;

# 2024-08-20 ---
# CREATE TABLE `user_card_coach` (
#   `uuid` bigint(20)  NOT NULL  COMMENT '主键',
#   `coach_uuid` bigint(20) NOT NULL COMMENT '教练UUID store_staff#uuid',
#   `coach_name` varchar(30) NOT NULL COMMENT '教练名称 store_staff#name',
#   `user_card_uuid` bigint(20) NOT NULL COMMENT '会员卡UUID user_card#uuid',
#   `is_delete` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否删除 0:未删除 1:已删除',
#   `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
#   `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
#   PRIMARY KEY (`uuid`),
#   UNIQUE KEY `uk_coach_user_card` (`coach_uuid`, `user_card_uuid`),
#   KEY `idx_user_card_uuid` (`user_card_uuid`),
#   KEY `idx_coach_uuid` (`coach_uuid`)
# ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='会员卡授课教练信息';
#
# alter table user_card
#     modify coach_name text null comment '授课教练名称,多教练英文逗号分隔 store_staff#name';
#
# alter table user_card
#     modify coach_uuid text null comment '授课教练uuid,多教练英文逗号分隔 store_staff#uuid';
#
# alter table store
#     add user_card_show_status tinyint(1) default 1 null comment '用户端会员卡显示状态 0:不显示 1:显示 默认 1';













