# 新增 会员卡审核人管理菜单
INSERT INTO menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
VALUES ('1211e86393644d32a780c46968a0b9bd', 846782090753224704, '会员卡审核人管理', '9ca04e9509fe11ecbf1c00163e0434b9',
        13, DEFAULT, DEFAULT, '/chain-manage/member-audit-manage', 1, DEFAULT);
# 管理员角色新增 会员卡审核人管理 菜单权限
INSERT INTO group_menus (menu_uuid, group_uuid, create_time, update_time)
VALUES ('1211e86393644d32a780c46968a0b9bd', '3', DEFAULT, DEFAULT);

## 会员卡审核人管理 子菜单 新增、编辑、删除
INSERT INTO menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
VALUES ('da98c1da2ac3448ba33dd3b93e7d2bc5', 846782090753224704, '新增', '1211e86393644d32a780c46968a0b9bd', 1, DEFAULT,
        DEFAULT, '/chain-manage/member-audit-manage/form?type=add', 1, DEFAULT);

INSERT INTO menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
VALUES ('ccaf3277fa6d45aab9b2c1af9dec6cd6', 846782090753224704, '编辑', '1211e86393644d32a780c46968a0b9bd', 2, DEFAULT,
        DEFAULT, '/chain-manage/member-audit-manage/form?type=edit', 1, DEFAULT);

INSERT INTO menus (uuid, company_uuid, name, parent_uuid, sort, create_time, update_time, url, type, classes)
VALUES ('8b66d7eb86d74adcb92c53ea6b867216', 846782090753224704, '删除', '1211e86393644d32a780c46968a0b9bd', 3, DEFAULT,
        DEFAULT, DEFAULT, 1, DEFAULT);

## 管理员角色新增 会员卡审核人管理 子菜单 新增、编辑、删除 菜单权限
INSERT INTO group_menus (menu_uuid, group_uuid, create_time, update_time)
VALUES ('da98c1da2ac3448ba33dd3b93e7d2bc5', '3', DEFAULT, DEFAULT);
INSERT INTO group_menus (menu_uuid, group_uuid, create_time, update_time)
VALUES ('ccaf3277fa6d45aab9b2c1af9dec6cd6', '3', DEFAULT, DEFAULT);
INSERT INTO group_menus (menu_uuid, group_uuid, create_time, update_time)
VALUES ('8b66d7eb86d74adcb92c53ea6b867216', '3', DEFAULT, DEFAULT);

#用户审核人管理 表
CREATE TABLE user_approval_template (
  user_approval_template_uuid             BIGINT  NOT NULL  COMMENT '主键ID',
  template_name  VARCHAR(200)    NOT NULL COMMENT '模板名称',
  level_count    TINYINT         NOT NULL  COMMENT '1:仅一级 2:一级+二级',
  create_time     TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  update_time    TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (user_approval_template_uuid)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户审批模板';

CREATE TABLE user_approval_level_admin (
  user_approval_level_admin_uuid             BIGINT UNSIGNED NOT NULL  COMMENT '主键ID',
  user_approval_template_uuid    BIGINT  NOT NULL COMMENT '模板ID',
  level_no       TINYINT         NOT NULL COMMENT '级别: 1/2',
  admin_uuid      BIGINT  NOT NULL COMMENT '审批人(admin.uuid)',
  create_time     TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (user_approval_level_admin_uuid),
  UNIQUE KEY uk_member_once (user_approval_template_uuid, admin_uuid, level_no)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户审批人员表';


CREATE TABLE user_approval_template_store (
  user_approval_template_store_uuid BIGINT  NOT NULL COMMENT '主键ID',
  user_approval_template_uuid   BIGINT UNSIGNED NOT NULL COMMENT '模板ID user_approval_template.user_approval_template_uuid',
  store_uuid      BIGINT  NOT NULL COMMENT '门店ID store.uuid',
  create_time    TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (user_approval_template_store_uuid),
  UNIQUE KEY uk_tpl_store (user_approval_template_uuid, store_uuid),
  KEY idx_store_uuid (store_uuid)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户审核模板适用门店表';


CREATE INDEX idx_template_name
ON user_approval_template (template_name(191));

-- 会员卡预约次数配置表(下月生效功能)
-- 创建时间: 2024-12-01
-- 需求: 会员卡预约次数配置下月生效

CREATE TABLE `user_card_reservation_config` (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `user_card_uuid` bigint(20) NOT NULL COMMENT '会员卡UUID',
  `company_uuid` bigint(20) NOT NULL COMMENT '公司UUID',
  `store_uuid` bigint(20) DEFAULT NULL COMMENT '门店UUID',
  `term_card_reservation_limit` int(11) NOT NULL COMMENT '期限卡每月可约次数上限取值',
  `term_card_reservation_limit_type` tinyint(1) NOT NULL COMMENT '期限卡每月可预约次数上限类型 0:自然月限制(每月的1号到月底) 1:开卡日期限制(开卡日期的当月到下月的开卡日期)',
  `effective_date` date NOT NULL COMMENT '生效日期(格式:2025-01-01)',
  `effective_month` varchar(7) NOT NULL COMMENT '生效月份(格式:2025-01),用于唯一索引去重',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态: 0-待生效, 1-已生效, 2-已作废',
  `create_uuid` bigint(20) DEFAULT NULL COMMENT '创建人UUID',
  `create_name` varchar(64) DEFAULT NULL COMMENT '创建人姓名',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_user_card_month` (`user_card_uuid`, `effective_month`) COMMENT '同一会员卡在同一月份只有一条待生效配置',
  KEY `idx_user_card_uuid` (`user_card_uuid`) COMMENT '会员卡UUID索引',
  KEY `idx_effective_date` (`effective_date`) COMMENT '生效日期索引',
  KEY `idx_status` (`status`) COMMENT '状态索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员卡预约次数配置表(下月生效)';


