# ALTER TABLE
#     `t_device`
# ADD
#     COLUMN `system_device_serial_number` varchar(200) NULL COMMENT '设备序列号(系统唯一,序列号激活设备流程) t_device_serial_number.device_serial_number';
#
# -- 设备表序列号索引
# CREATE INDEX `idx_system_device_serial_number` ON `t_device` (`system_device_serial_number`);
#
#
# -- 设备序列号表
# CREATE TABLE `t_device_serial_number` (
#     `id` BIGINT NOT NULL COMMENT '主键ID',
#     -- 设备组ID
#     `device_group_id` BIGINT NOT NULL COMMENT '设备组ID',
#     -- 设备序列号
#     `system_device_serial_number` varchar(200) NOT NULL COMMENT '设备序列号',
#     -- 绑定设备MAC地址
#     `device_mac_address` varchar(200) NULL COMMENT '绑定设备MAC地址',
#     -- 序号
#     `serial_number` INT NOT NULL COMMENT '序号(同一个设备组内的序号)',
#     -- 设备类型 0:相框 1:AI闹钟
#     `device_type` TINYINT NOT NULL COMMENT '设备类型 0:相框 1:AI闹钟',
#     -- 序列号状态 0:未激活 1:已激活 default 0
#     `status` TINYINT NOT NULL DEFAULT 0 COMMENT '序列号状态 0:未激活 1:已激活 default 0',
#     -- 是否删除 0:未删除 1:已删除 default 0
#     `is_deleted` TINYINT NOT NULL DEFAULT 0 COMMENT '是否删除 0:未删除 1:已删除 default 0',
#     -- 创建时间 default CURRENT_TIMESTAMP
#     `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
#     -- 更新时间 default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
#     `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
#     PRIMARY KEY (`id`)
# ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COMMENT = '设备序列号表';
#
# -- 设备序列号表索引
# CREATE INDEX `idx_device_group_id` ON `t_device_serial_number` (`device_group_id`);
#
# -- 设备序列号表唯一索引
# CREATE UNIQUE INDEX `idx_system_device_serial_number` ON `t_device_serial_number` (`system_device_serial_number`);
#
#
# alter table t_device_group
#     add activation_type tinyint default 0 null comment '激活方式 0:公钥激活 1:序列号激活 default:0(公钥激活)' after device_group_id;
#
#
# alter table t_device_group
#     add device_group_type tinyint default 0 null comment '设备组分类 0:相框 1:AI闹钟 default:0(相框)' after device_group_id;
